<?php
// SEO-optimized 500 error page
http_response_code(500);

// Set SEO variables for this page
$seo_title = 'Server Error - Panadite Academy | We\'ll Be Back Soon';
$seo_description = 'We\'re experiencing technical difficulties. Panadite Academy will be back online shortly. Explore our professional courses and certifications.';
$seo_keywords = 'server error, maintenance, Panadite Academy, online learning, professional courses, technical difficulties';

// Include comprehensive SEO headers
require_once __DIR__ . '/includes/seo_header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- SEO headers are already included above -->
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    
    <style>
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
        }
        
        .error-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .error-card {
            background: white;
            border-radius: 20px;
            padding: 60px 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 600px;
            margin: 0 20px;
        }
        
        .error-number {
            font-size: 120px;
            font-weight: 900;
            color: #f59e0b;
            line-height: 1;
            margin-bottom: 20px;
        }
        
        .error-title {
            font-size: 32px;
            font-weight: 700;
            color: #1a202c;
            margin-bottom: 16px;
        }
        
        .error-description {
            font-size: 18px;
            color: #64748b;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        
        .btn-primary {
            background: #276BE4;
            border: none;
            border-radius: 12px;
            padding: 16px 32px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: #1e5bcc;
            transform: translateY(-2px);
        }
        
        .loading-animation {
            display: inline-block;
            width: 40px;
            height: 40px;
            border: 4px solid #e2e8f0;
            border-radius: 50%;
            border-top-color: #276BE4;
            animation: spin 1s ease-in-out infinite;
            margin: 20px 0;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .auto-refresh {
            background: #f8fafc;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin: 30px 0;
        }
    </style>
</head>

<body>
    <div class="error-container">
        <div class="error-card">
            <!-- Logo -->
            <div class="mb-4">
                <img src="/logo.jpeg" alt="Panadite Academy" style="height: 60px; width: auto;">
            </div>
            
            <!-- Error Number -->
            <div class="error-number">500</div>
            
            <!-- Error Title -->
            <h1 class="error-title">Server Error</h1>
            
            <!-- Error Description -->
            <p class="error-description">
                We're experiencing some technical difficulties right now. 
                Our team has been notified and is working to resolve this issue quickly.
            </p>
            
            <!-- Loading Animation -->
            <div class="loading-animation"></div>
            
            <!-- Auto Refresh Section -->
            <div class="auto-refresh">
                <h5 style="color: #1a202c; margin-bottom: 12px;">
                    <i class="fas fa-sync-alt me-2"></i>Auto-Refresh Active
                </h5>
                <p style="color: #64748b; margin-bottom: 0;">
                    This page will automatically refresh every 30 seconds
                </p>
                <small style="color: #64748b;">
                    Next refresh in: <span id="countdown">30</span> seconds
                </small>
            </div>
            
            <!-- Action Buttons -->
            <div class="d-flex flex-column flex-md-row gap-3 justify-content-center mb-4">
                <button onclick="window.location.reload()" class="btn btn-primary">
                    <i class="fas fa-redo me-2"></i>Try Again
                </button>
                <a href="/" class="btn btn-outline-primary">
                    <i class="fas fa-home me-2"></i>Back to Home
                </a>
            </div>
            
            <!-- Status Updates -->
            <div style="margin-top: 40px; padding-top: 30px; border-top: 1px solid #e2e8f0;">
                <p style="color: #64748b; margin-bottom: 16px;">For real-time updates:</p>
                <div class="d-flex justify-content-center gap-3">
                    <a href="/contact.php" style="color: #276BE4; text-decoration: none; font-weight: 600;">
                        <i class="fas fa-life-ring me-2"></i>Contact Support
                    </a>
                    <span style="color: #e2e8f0;">|</span>
                    <a href="https://twitter.com/PanaditeAcademy" target="_blank" style="color: #276BE4; text-decoration: none; font-weight: 600;">
                        <i class="fab fa-twitter me-2"></i>Status Updates
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auto Refresh Script -->
    <script>
        let countdown = 30;
        const countdownElement = document.getElementById('countdown');
        
        const timer = setInterval(() => {
            countdown--;
            countdownElement.textContent = countdown;
            
            if (countdown <= 0) {
                window.location.reload();
            }
        }, 1000);
        
        // Track server errors for monitoring
        if (typeof gtag !== 'undefined') {
            gtag('event', 'server_error', {
                'error_code': '500',
                'page_url': window.location.href
            });
        }
    </script>
</body>
</html>
