<?php
/**
 * Database Migration: Add Course Passing Grade Column to Courses Table
 * This adds the missing course_passing_grade field for certificate eligibility
 */

require_once '../config/db_connect.php';

echo "<h2>🎯 Adding Course Passing Grade Column</h2>";
echo "<div style='font-family: Arial, sans-serif; max-width: 800px; margin: 20px;'>";

try {
    // Check if column already exists
    $check_query = "SHOW COLUMNS FROM courses LIKE 'course_passing_grade'";
    $result = $conn->query($check_query);
    
    if ($result->num_rows > 0) {
        echo "<div style='background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
        echo "<h3>⚠️ Column Already Exists</h3>";
        echo "<p>The course_passing_grade column already exists in the courses table.</p>";
        echo "</div>";
    } else {
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
        echo "<h3>🔧 Adding Course Passing Grade Column</h3>";
        
        // Add the new column
        $alter_query = "
            ALTER TABLE courses 
            ADD COLUMN course_passing_grade DECIMAL(5,2) DEFAULT 60.00 
            COMMENT 'Minimum percentage grade required to earn certificate'
        ";
        
        if ($conn->query($alter_query) === TRUE) {
            echo "<p>✅ <strong>Successfully added course_passing_grade column:</strong></p>";
            echo "<ul>";
            echo "<li><strong>course_passing_grade:</strong> DECIMAL(5,2) DEFAULT 60.00</li>";
            echo "</ul>";
        } else {
            throw new Exception("Error adding column: " . $conn->error);
        }
        echo "</div>";
    }
    
    // Update existing courses to have proper passing grade if they don't
    echo "<div style='background: #e2e3e5; border: 1px solid #c6c8ca; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>🔄 Updating Existing Courses</h3>";
    
    $update_query = "
        UPDATE courses 
        SET course_passing_grade = 60.00 
        WHERE course_passing_grade IS NULL
    ";
    
    if ($conn->query($update_query) === TRUE) {
        $affected_rows = $conn->affected_rows;
        echo "<p>✅ Updated {$affected_rows} courses with default passing grade of 60%</p>";
    } else {
        echo "<p>❌ Error updating existing courses: " . $conn->error . "</p>";
    }
    echo "</div>";
    
    // Show sample data
    echo "<div style='background: #f8f9fa; border: 1px solid #dee2e6; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>📊 Current Courses with Passing Grades</h3>";
    
    $sample_query = "
        SELECT course_id, title, assignment_weight, quiz_weight, course_passing_grade
        FROM courses 
        ORDER BY course_id DESC 
        LIMIT 5
    ";
    
    $sample_result = $conn->query($sample_query);
    
    if ($sample_result && $sample_result->num_rows > 0) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 10px 0;'>";
        echo "<tr style='background: #f8f9fa;'>";
        echo "<th style='padding: 8px;'>Course ID</th>";
        echo "<th style='padding: 8px;'>Title</th>";
        echo "<th style='padding: 8px;'>Assignment Weight</th>";
        echo "<th style='padding: 8px;'>Quiz Weight</th>";
        echo "<th style='padding: 8px;'>Passing Grade</th>";
        echo "</tr>";
        
        while ($row = $sample_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td style='padding: 8px;'>" . htmlspecialchars($row['course_id']) . "</td>";
            echo "<td style='padding: 8px;'>" . htmlspecialchars($row['title']) . "</td>";
            echo "<td style='padding: 8px;'>" . htmlspecialchars($row['assignment_weight']) . "%</td>";
            echo "<td style='padding: 8px;'>" . htmlspecialchars($row['quiz_weight']) . "%</td>";
            echo "<td style='padding: 8px; font-weight: bold; color: #f6ad55;'>" . htmlspecialchars($row['course_passing_grade']) . "%</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No courses found in the database.</p>";
    }
    echo "</div>";
    
    echo "<div style='background: #d1ecf1; border: 1px solid #bee5eb; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>🎯 Next Steps</h3>";
    echo "<ol>";
    echo "<li><strong>Update Certificate Logic:</strong> Use course_passing_grade instead of 100% requirement</li>";
    echo "<li><strong>Update Course Creation:</strong> Save the new field when courses are created</li>";
    echo "<li><strong>Fix Current Bug:</strong> Student with 66.67% should be eligible if passing grade is 60%</li>";
    echo "</ol>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>❌ Error</h3>";
    echo "<p>An error occurred: " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}

echo "</div>";
?>
