<?php
// Initialize session if not started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in and is an admin
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Include database connection
include_once "../../config/db_connect.php";

// Set content type to JSON
header('Content-Type: application/json');

try {
    // Query to get all teachers
    $query = "SELECT u.user_id, u.first_name, u.last_name, u.email, u.status 
              FROM users u 
              LEFT JOIN teacher_profiles tp ON u.user_id = tp.teacher_id
              WHERE u.role = 'teacher'
              ORDER BY u.first_name, u.last_name";
    
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    $teachers = [];
    
    // Fetch all teachers
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $teachers[] = [
            'user_id' => $row['user_id'],
            'first_name' => htmlspecialchars($row['first_name']),
            'last_name' => htmlspecialchars($row['last_name']),
            'email' => htmlspecialchars($row['email']),
            'status' => $row['status'],
            'initials' => strtoupper(substr($row['first_name'], 0, 1) . substr($row['last_name'], 0, 1))
        ];
    }
    
    // Return success response with teachers data
    echo json_encode([
        'success' => true,
        'data' => $teachers
    ]);
    
} catch (PDOException $e) {
    // Return error response
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
