<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set content type to plain text for better readability
header('Content-Type: text/plain; charset=utf-8');

echo "🚀 Starting partnerships table creation...\n\n";

require_once 'config/database.php';

// Check if database connection exists
if (!isset($conn)) {
    echo "❌ Database connection not found!\n";
    exit;
}

echo "✅ Database connection established!\n";

// Create partnerships table
$createTableQuery = "
CREATE TABLE IF NOT EXISTS partnerships (
    id INT AUTO_INCREMENT PRIMARY KEY,
    company_name VARCHAR(255) NOT NULL,
    logo_path VARCHAR(255) NOT NULL,
    website_url VARCHAR(255) DEFAULT NULL,
    description TEXT DEFAULT NULL,
    display_order INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)";

try {
    if ($conn->query($createTableQuery) === TRUE) {
        echo "✅ Partnerships table created successfully!\n";
        
        // Insert some sample data (the companies from the image)
        $samplePartnerships = [
            [
                'company_name' => 'Google',
                'logo_path' => 'assets/images/partnerships/google.png',
                'website_url' => 'https://www.google.com',
                'description' => 'Global technology company focusing on Internet-related services and products.',
                'display_order' => 1
            ],
            [
                'company_name' => 'Amazon',
                'logo_path' => 'assets/images/partnerships/amazon.png',
                'website_url' => 'https://www.amazon.com',
                'description' => 'American multinational technology company focusing on e-commerce, cloud computing, and AI.',
                'display_order' => 2
            ],
            [
                'company_name' => 'Apple',
                'logo_path' => 'assets/images/partnerships/apple.png',
                'website_url' => 'https://www.apple.com',
                'description' => 'American multinational technology company that designs and manufactures consumer electronics.',
                'display_order' => 3
            ],
            [
                'company_name' => 'IBM',
                'logo_path' => 'assets/images/partnerships/ibm.png',
                'website_url' => 'https://www.ibm.com',
                'description' => 'International technology company that provides integrated solutions and products.',
                'display_order' => 4
            ],
            [
                'company_name' => 'Oracle',
                'logo_path' => 'assets/images/partnerships/oracle.png',
                'website_url' => 'https://www.oracle.com',
                'description' => 'American multinational computer technology corporation specializing in database software and cloud computing.',
                'display_order' => 5
            ],
            [
                'company_name' => 'Accenture',
                'logo_path' => 'assets/images/partnerships/accenture.png',
                'website_url' => 'https://www.accenture.com',
                'description' => 'Global professional services company with leading capabilities in digital, cloud and security.',
                'display_order' => 6
            ]
        ];
        
        // Insert sample data
        $insertQuery = "INSERT INTO partnerships (company_name, logo_path, website_url, description, display_order, is_active) VALUES (?, ?, ?, ?, ?, 1)";
        $stmt = $conn->prepare($insertQuery);
        
        foreach ($samplePartnerships as $partnership) {
            $stmt->bind_param("ssssi", 
                $partnership['company_name'],
                $partnership['logo_path'],
                $partnership['website_url'],
                $partnership['description'],
                $partnership['display_order']
            );
            
            if ($stmt->execute()) {
                echo "✅ Added partnership: " . $partnership['company_name'] . "\n";
            } else {
                echo "❌ Failed to add partnership: " . $partnership['company_name'] . "\n";
            }
        }
        
        echo "\n🎉 Partnerships table and sample data created successfully!\n";
        echo "📁 Make sure to create the assets/images/partnerships/ directory and add your logo images.\n";
        
    } else {
        echo "❌ Error creating partnerships table: " . $conn->error;
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}

$conn->close();
?>
