<?php
// Include database connection
include_once "../config/db_connect.php";

// Set content type to plain text for debugging
header('Content-Type: text/plain');

try {
    // SQL to create teacher_student_assignments table
    $sql = "CREATE TABLE IF NOT EXISTS teacher_student_assignments (
        assignment_id INT AUTO_INCREMENT PRIMARY KEY,
        teacher_id INT NOT NULL,
        student_id INT NOT NULL,
        assigned_by INT NOT NULL COMMENT 'Admin ID who made the assignment',
        assigned_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        status ENUM('active', 'inactive') DEFAULT 'active',
        notes TEXT,
        FOREIGN KEY (teacher_id) REFERENCES users(user_id) ON DELETE CASCADE,
        FOREIGN KEY (student_id) REFERENCES users(user_id) ON DELETE CASCADE,
        FOREIGN KEY (assigned_by) REFERENCES users(user_id) ON DELETE CASCADE,
        UNIQUE KEY (teacher_id, student_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

    // Execute the query
    $conn->exec($sql);
    echo "Teacher-student assignments table created successfully!\n";
    
    // Add sample data for testing if needed
    /*
    $insertSql = "INSERT INTO teacher_student_assignments (teacher_id, student_id, assigned_by, status) 
                 VALUES 
                 (2, 5, 1, 'active'),
                 (2, 6, 1, 'active'),
                 (3, 7, 1, 'active')";
    $conn->exec($insertSql);
    echo "Sample data inserted successfully!";
    */
    
} catch(PDOException $e) {
    echo "Error creating table: " . $e->getMessage();
}

// Close connection
$conn = null;
?>
