<?php
require_once '../auth/functions.php';
requireRole('admin');
require_once '../config/db_connect.php';

echo "<!DOCTYPE html>";
echo "<html><head>";
echo "<title>Debug Accreditation Email System</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<style>.debug-section { background: #f8f9fa; padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #007bff; }</style>";
echo "</head><body>";
echo "<div class='container mt-4'>";

echo "<h1>🔍 Debug Accreditation Email System</h1>";
echo "<p class='text-muted'>Debugging email failure for accreditation requests</p>";

// 1. Check table structure
echo "<div class='debug-section'>";
echo "<h3>📋 1. Table Structure Analysis</h3>";

echo "<h5>Accreditation Requests Table:</h5>";
$result = $conn->query("DESCRIBE accreditation_requests");
if ($result) {
    echo "<table class='table table-sm table-bordered'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td><strong>" . $row['Field'] . "</strong></td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert alert-danger'>❌ Failed to describe accreditation_requests table: " . $conn->error . "</div>";
}

echo "<h5>Users Table:</h5>";
$result = $conn->query("DESCRIBE users");
if ($result) {
    echo "<table class='table table-sm table-bordered'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td><strong>" . $row['Field'] . "</strong></td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert alert-danger'>❌ Failed to describe users table: " . $conn->error . "</div>";
}

echo "<h5>Courses Table:</h5>";
$result = $conn->query("DESCRIBE courses");
if ($result) {
    echo "<table class='table table-sm table-bordered'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td><strong>" . $row['Field'] . "</strong></td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert alert-danger'>❌ Failed to describe courses table: " . $conn->error . "</div>";
}
echo "</div>";

// 2. Show all accreditation requests data
echo "<div class='debug-section'>";
echo "<h3>📊 2. All Accreditation Requests Data</h3>";
$result = $conn->query("SELECT * FROM accreditation_requests ORDER BY request_date DESC LIMIT 10");
if ($result && $result->num_rows > 0) {
    echo "<table class='table table-sm table-striped'>";
    echo "<tr>";
    $fields = $result->fetch_fields();
    foreach ($fields as $field) {
        echo "<th>" . $field->name . "</th>";
    }
    echo "</tr>";
    
    $result->data_seek(0);
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        foreach ($row as $value) {
            echo "<td>" . htmlspecialchars($value) . "</td>";
        }
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert alert-warning'>⚠️ No accreditation requests found or error: " . $conn->error . "</div>";
}
echo "</div>";

// 3. Test the actual email query
echo "<div class='debug-section'>";
echo "<h3>🧪 3. Test Email Function Query</h3>";

// Get a sample request ID
$sample_result = $conn->query("SELECT request_id FROM accreditation_requests ORDER BY request_date DESC LIMIT 1");
if ($sample_result && $sample_result->num_rows > 0) {
    $sample_row = $sample_result->fetch_assoc();
    $test_request_id = $sample_row['request_id'];
    
    echo "<p><strong>Testing with Request ID:</strong> " . $test_request_id . "</p>";
    
    // Test the exact query from the email function
    $test_query = "SELECT ar.request_id, ar.payment_amount, ar.assignment_filename, ar.updated_at, ar.course_id, u.first_name, u.last_name, u.email, u.user_id, c.title as course_title, c.description FROM accreditation_requests ar JOIN users u ON ar.student_id = u.user_id JOIN courses c ON ar.course_id = c.course_id WHERE ar.request_id = ?";
    
    echo "<div class='alert alert-info'>";
    echo "<strong>Query:</strong><br><code>" . htmlspecialchars($test_query) . "</code>";
    echo "</div>";
    
    $stmt = $conn->prepare($test_query);
    if ($stmt) {
        echo "<div class='alert alert-success'>✅ Query prepared successfully</div>";
        $stmt->bind_param("i", $test_request_id);
        if ($stmt->execute()) {
            echo "<div class='alert alert-success'>✅ Query executed successfully</div>";
            $result = $stmt->get_result();
            if ($result && $result->num_rows > 0) {
                $details = $result->fetch_assoc();
                echo "<div class='alert alert-success'>✅ Data retrieved successfully</div>";
                echo "<h6>Retrieved Data:</h6>";
                echo "<table class='table table-sm table-bordered'>";
                foreach ($details as $key => $value) {
                    echo "<tr><td><strong>" . $key . "</strong></td><td>" . htmlspecialchars($value) . "</td></tr>";
                }
                echo "</table>";
                
                // Test email variables
                echo "<h6>Email Variables:</h6>";
                $student_name = $details['first_name'] . ' ' . $details['last_name'];
                $student_email = $details['email'];
                $course_title = $details['course_title'];
                $course_id = $details['course_id'];
                
                echo "<table class='table table-sm table-bordered'>";
                echo "<tr><td><strong>student_name</strong></td><td>" . htmlspecialchars($student_name) . "</td></tr>";
                echo "<tr><td><strong>student_email</strong></td><td>" . htmlspecialchars($student_email) . "</td></tr>";
                echo "<tr><td><strong>course_title</strong></td><td>" . htmlspecialchars($course_title) . "</td></tr>";
                echo "<tr><td><strong>course_id</strong></td><td>" . htmlspecialchars($course_id) . "</td></tr>";
                echo "</table>";
                
            } else {
                echo "<div class='alert alert-warning'>⚠️ Query returned no results</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>❌ Query execution failed: " . $stmt->error . "</div>";
        }
    } else {
        echo "<div class='alert alert-danger'>❌ Failed to prepare query: " . $conn->error . "</div>";
    }
} else {
    echo "<div class='alert alert-warning'>⚠️ No accreditation requests found to test with</div>";
}
echo "</div>";

// 4. Test email function directly
echo "<div class='debug-section'>";
echo "<h3>📧 4. Test Email Function Execution</h3>";

if (isset($test_request_id)) {
    echo "<p><strong>Testing sendAssessmentApprovalEmail($test_request_id)</strong></p>";
    
    // Include the email function
    function sendAssessmentApprovalEmailDebug($request_id) {
        global $conn;
        
        echo "<div class='mt-3'>";
        echo "<h6>📋 Debug Steps:</h6>";
        echo "<ol>";
        
        try {
            echo "<li>Starting function execution...</li>";
            
            // Get request, student and course details  
            $stmt = $conn->prepare("SELECT ar.request_id, ar.payment_amount, ar.assignment_filename, ar.updated_at, ar.course_id, u.first_name, u.last_name, u.email, u.user_id, c.title as course_title, c.description FROM accreditation_requests ar JOIN users u ON ar.student_id = u.user_id JOIN courses c ON ar.course_id = c.course_id WHERE ar.request_id = ?");
            
            if (!$stmt) {
                echo "<li class='text-danger'>❌ Failed to prepare query: " . $conn->error . "</li>";
                echo "</ol></div>";
                return false;
            }
            
            echo "<li>✅ Query prepared successfully</li>";
            
            $stmt->bind_param("i", $request_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $details = $result->fetch_assoc();
            
            if (!$details) {
                echo "<li class='text-danger'>❌ No data found for request ID: $request_id</li>";
                echo "</ol></div>";
                return false;
            }
            
            echo "<li>✅ Data retrieved successfully</li>";
            
            $student_name = $details['first_name'] . ' ' . $details['last_name'];
            $student_email = $details['email'];
            $course_title = $details['course_title'];
            $course_id = $details['course_id'];
            $request_id_formatted = str_pad($request_id, 6, '0', STR_PAD_LEFT);
            $approval_date = date('M j, Y', strtotime($details['updated_at']));
            
            echo "<li>✅ Variables prepared: " . htmlspecialchars($student_email) . "</li>";
            
            // Create email content
            $subject = "🎉 Assessment Approved: Request #$request_id_formatted is Ready!";
            $message = "Test email content...";
            
            echo "<li>✅ Email content created</li>";
            
            // Try direct email sending
            if (function_exists('sendEmailNow')) {
                echo "<li>📧 sendEmailNow function exists, attempting to send...</li>";
                $result = sendEmailNow($student_email, $subject, $message);
                if ($result) {
                    echo "<li class='text-success'>✅ sendEmailNow succeeded!</li>";
                    echo "</ol></div>";
                    return true;
                } else {
                    echo "<li class='text-warning'>⚠️ sendEmailNow failed, trying fallback...</li>";
                }
            } else {
                echo "<li class='text-warning'>⚠️ sendEmailNow function not found, using fallback...</li>";
            }
            
            // Fallback to native PHP mail
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= "From: noreply@panaditeacademy.com" . "\r\n";
            
            $mail_result = mail($student_email, $subject, $message, $headers);
            if ($mail_result) {
                echo "<li class='text-success'>✅ PHP mail() succeeded!</li>";
            } else {
                echo "<li class='text-danger'>❌ PHP mail() failed!</li>";
            }
            
            echo "</ol></div>";
            return $mail_result;
            
        } catch (Exception $e) {
            echo "<li class='text-danger'>❌ Exception: " . $e->getMessage() . "</li>";
            echo "</ol></div>";
            return false;
        }
    }
    
    $test_result = sendAssessmentApprovalEmailDebug($test_request_id);
    echo "<div class='alert " . ($test_result ? "alert-success" : "alert-danger") . "'>";
    echo $test_result ? "✅ Email function test completed successfully!" : "❌ Email function test failed!";
    echo "</div>";
}
echo "</div>";

// 5. Check email service configuration
echo "<div class='debug-section'>";
echo "<h3>⚙️ 5. Email Service Configuration</h3>";

echo "<h6>Function Availability:</h6>";
echo "<ul>";
echo "<li>sendEmailNow: " . (function_exists('sendEmailNow') ? '✅ Available' : '❌ Not Available') . "</li>";
echo "<li>mail: " . (function_exists('mail') ? '✅ Available' : '❌ Not Available') . "</li>";
echo "</ul>";

echo "<h6>PHP Mail Settings:</h6>";
echo "<ul>";
echo "<li>sendmail_path: " . ini_get('sendmail_path') . "</li>";
echo "<li>SMTP: " . ini_get('SMTP') . "</li>";
echo "<li>smtp_port: " . ini_get('smtp_port') . "</li>";
echo "</ul>";
echo "</div>";

echo "<div class='mt-4'>";
echo "<a href='accreditation_requests.php' class='btn btn-primary'>← Back to Accreditation Requests</a>";
echo "</div>";

echo "</div></body></html>";
?>
