<?php
// Debug script to show all approved documents
require_once '../auth/functions.php';
requireRole('admin');

echo "<h1>🔍 Debug: All Approved Documents</h1>";
echo "<style>
body { font-family: Arial, sans-serif; margin: 20px; }
table { border-collapse: collapse; width: 100%; margin: 20px 0; }
th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
th { background-color: #f2f2f2; }
tr:nth-child(even) { background-color: #f9f9f9; }
.status-approved { background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; }
.status-pending { background: #fff3cd; color: #856404; padding: 4px 8px; border-radius: 4px; }
.status-rejected { background: #f8d7da; color: #721c24; padding: 4px 8px; border-radius: 4px; }
</style>";

// Test database connection
if (!$conn) {
    die("❌ Database connection failed: " . mysqli_connect_error());
}
echo "✅ Database connected successfully<br><br>";

// Check if table exists
$table_check = $conn->query("SHOW TABLES LIKE 'library_submissions'");
if ($table_check->num_rows == 0) {
    die("❌ Table 'library_submissions' does not exist!");
}
echo "✅ Table 'library_submissions' exists<br><br>";

// Get ALL records from library_submissions
echo "<h2>📊 All Library Submissions:</h2>";
$query = "
    SELECT ls.*, 
           u.first_name, u.last_name, u.email,
           c.category_name
    FROM library_submissions ls
    LEFT JOIN users u ON ls.teacher_id = u.user_id
    LEFT JOIN library_categories c ON ls.category_id = c.category_id
    ORDER BY ls.submission_date DESC
";

$result = $conn->query($query);
if (!$result) {
    die("❌ Query failed: " . $conn->error);
}

echo "📈 Total records found: " . $result->num_rows . "<br><br>";

if ($result->num_rows > 0) {
    echo "<table>";
    echo "<tr>
            <th>ID</th>
            <th>Title</th>
            <th>Teacher</th>
            <th>Category</th>
            <th>Status</th>
            <th>File Path</th>
            <th>Submission Date</th>
            <th>Review Date</th>
          </tr>";
    
    $status_counts = ['pending' => 0, 'approved' => 0, 'rejected' => 0];
    
    while ($row = $result->fetch_assoc()) {
        $status_counts[$row['status']]++;
        
        $status_class = 'status-' . $row['status'];
        $teacher_name = $row['first_name'] ? ($row['first_name'] . ' ' . $row['last_name']) : 'Unknown';
        
        echo "<tr>";
        echo "<td>" . $row['submission_id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['title']) . "</td>";
        echo "<td>" . htmlspecialchars($teacher_name) . "</td>";
        echo "<td>" . htmlspecialchars($row['category_name'] ?? 'Uncategorized') . "</td>";
        echo "<td><span class='$status_class'>" . strtoupper($row['status']) . "</span></td>";
        echo "<td>" . htmlspecialchars($row['file_path']) . "</td>";
        echo "<td>" . $row['submission_date'] . "</td>";
        echo "<td>" . ($row['review_date'] ?? 'Not reviewed') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h3>📊 Status Summary:</h3>";
    echo "<ul>";
    echo "<li>🟡 <strong>Pending:</strong> " . $status_counts['pending'] . "</li>";
    echo "<li>🟢 <strong>Approved:</strong> " . $status_counts['approved'] . "</li>";
    echo "<li>🔴 <strong>Rejected:</strong> " . $status_counts['rejected'] . "</li>";
    echo "</ul>";
    
} else {
    echo "❌ No library submissions found in database!";
}

// Check if public_library_resources table exists and has data
echo "<br><h2>🔍 Checking public_library_resources table:</h2>";
$public_table_check = $conn->query("SHOW TABLES LIKE 'public_library_resources'");
if ($public_table_check->num_rows > 0) {
    echo "✅ Table 'public_library_resources' exists<br>";
    $public_result = $conn->query("SELECT COUNT(*) as count FROM public_library_resources");
    if ($public_result) {
        $public_count = $public_result->fetch_assoc()['count'];
        echo "📈 Records in public_library_resources: " . $public_count . "<br>";
        
        if ($public_count > 0) {
            echo "<h3>📋 Public Library Resources:</h3>";
            $public_data = $conn->query("
                SELECT plr.*, u.first_name, u.last_name 
                FROM public_library_resources plr 
                LEFT JOIN users u ON plr.teacher_id = u.user_id 
                ORDER BY plr.publication_date DESC
            ");
            
            echo "<table>";
            echo "<tr><th>Resource ID</th><th>Title</th><th>Teacher</th><th>Publication Date</th><th>File Path</th></tr>";
            while ($pub_row = $public_data->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $pub_row['resource_id'] . "</td>";
                echo "<td>" . htmlspecialchars($pub_row['title']) . "</td>";
                echo "<td>" . htmlspecialchars(($pub_row['first_name'] ?? 'Unknown') . ' ' . ($pub_row['last_name'] ?? '')) . "</td>";
                echo "<td>" . $pub_row['publication_date'] . "</td>";
                echo "<td>" . htmlspecialchars($pub_row['file_path']) . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    }
} else {
    echo "❌ Table 'public_library_resources' does not exist<br>";
}

echo "<br><h2>🔧 Array Debug (what library_approvals.php should show):</h2>";

// Simulate the exact same query from library_approvals.php (UPDATED)
$all_submissions = [];
$approved_documents = [];
$pending_rejected = [];

echo "<h3>🔍 Testing the EXACT query from library_approvals.php:</h3>";
$stmt = $conn->prepare("
    SELECT ls.*, 
           u.first_name, u.last_name, u.email, u.username as teacher_name, 
           c.category_name,
           'submission' as source_table
    FROM library_submissions ls
    LEFT JOIN users u ON ls.teacher_id = u.user_id
    LEFT JOIN library_categories c ON ls.category_id = c.category_id
    ORDER BY ls.submission_date DESC
");

echo "Query: " . $stmt ? "✅ Prepared successfully" : "❌ Failed to prepare";
echo "<br>";

if ($stmt) {
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $all_submissions[] = $row;
        // Separate by status
        if ($row['status'] === 'approved') {
            $approved_documents[] = $row;
        } elseif (in_array($row['status'], ['pending', 'rejected'])) {
            $pending_rejected[] = $row;
        }
    }
    $stmt->close();
}

echo "🔢 <strong>Array Counts (what tabs should show):</strong><br>";
echo "• All Submissions: " . count($all_submissions) . "<br>";
echo "• Approved Documents: " . count($approved_documents) . "<br>";
echo "• Pending & Rejected: " . count($pending_rejected) . "<br><br>";

if (!empty($approved_documents)) {
    echo "<h3>✅ Approved Documents Array Contents:</h3>";
    echo "<table>";
    echo "<tr><th>ID</th><th>Title</th><th>Teacher</th><th>Status</th><th>Date</th></tr>";
    foreach ($approved_documents as $doc) {
        echo "<tr>";
        echo "<td>" . $doc['submission_id'] . "</td>";
        echo "<td>" . htmlspecialchars($doc['title']) . "</td>";
        echo "<td>" . htmlspecialchars($doc['first_name'] . ' ' . $doc['last_name']) . "</td>";
        echo "<td><span class='status-approved'>" . strtoupper($doc['status']) . "</span></td>";
        echo "<td>" . $doc['submission_date'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "❌ No approved documents found in array!";
}

$conn->close();
?>
