/**
 * Panadite Academy - Teacher Portal Modern UI
 * JavaScript for Navbar and Sidebar functionality
 */

document.addEventListener('DOMContentLoaded', function() {
    // Initialize sidebar and navbar functionality
    initSidebar();
    initDropdowns();
});

/**
 * Initialize sidebar toggle functionality
 */
function initSidebar() {
    const sidebarToggle = document.getElementById('sidebar-toggle');
    const sidebar = document.querySelector('.sidebar');
    const mainContent = document.querySelector('.main-content');
    const backdrop = document.querySelector('.sidebar-backdrop');
    
    // Check for saved sidebar state
    const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
    
    // Set initial state based on saved preference
    if (sidebarCollapsed) {
        sidebar.classList.add('collapsed');
        mainContent?.classList.add('collapsed');
    }
    
    // Toggle sidebar on button click
    sidebarToggle?.addEventListener('click', function() {
        if (window.innerWidth < 992) {
            // On mobile, show/hide sidebar with backdrop
            sidebar.classList.toggle('show');
            backdrop.classList.toggle('show');
        } else {
            // On desktop, collapse/expand sidebar
            sidebar.classList.toggle('collapsed');
            mainContent?.classList.toggle('collapsed');
            
            // Save sidebar state
            const isCollapsed = sidebar.classList.contains('collapsed');
            localStorage.setItem('sidebarCollapsed', isCollapsed);
        }
    });
    
    // Close sidebar when clicking outside on mobile
    backdrop?.addEventListener('click', function() {
        sidebar.classList.remove('show');
        backdrop.classList.remove('show');
    });
    
    // Handle window resize
    window.addEventListener('resize', function() {
        if (window.innerWidth >= 992) {
            sidebar.classList.remove('show');
            backdrop.classList.remove('show');
            
            // Restore saved state on desktop
            if (sidebarCollapsed) {
                sidebar.classList.add('collapsed');
                mainContent?.classList.add('collapsed');
            }
        }
    });
}

/**
 * Initialize dropdown functionality for sidebar menu items
 * Note: Dropdowns have been removed from the sidebar, this function is now simplified
 */
function initDropdowns() {
    // We've removed all dropdowns from the sidebar, so this function is mostly empty now
    console.log('Sidebar dropdowns have been removed - flat navigation structure enabled');
    
    // Legacy code for any remaining dropdowns elsewhere in the app
    const dropdownLinks = document.querySelectorAll('.sidebar-link.has-dropdown');
    if (dropdownLinks.length > 0) {
        console.log('Note: Some dropdown links still exist in the DOM');
    }
}

/**
 * Notification badge utilities
 */
const NotificationManager = {
    // Mark all notifications as read
    markAllNotificationsAsRead: function() {
        const badges = document.querySelectorAll('.notification-dropdown .badge');
        badges.forEach(badge => {
            badge.style.display = 'none';
        });
        
        // Should connect to backend API to mark notifications as read
        console.log('Marking all notifications as read');
        
        // Update the UI
        document.querySelector('.notification-dropdown .dropdown-menu').innerHTML = 
            '<p class="text-center py-3 mb-0">No new notifications</p>' +
            '<a href="notifications.php" class="dropdown-item text-center text-primary py-2">View all notifications</a>';
    },
    
    // Mark all messages as read
    markAllMessagesAsRead: function() {
        const badges = document.querySelectorAll('.messages-dropdown .badge');
        badges.forEach(badge => {
            badge.style.display = 'none';
        });
        
        // Should connect to backend API to mark messages as read
        console.log('Marking all messages as read');
        
        // Update the UI
        document.querySelector('.messages-dropdown .dropdown-menu').innerHTML = 
            '<p class="text-center py-3 mb-0">No new messages</p>' +
            '<a href="messages.php" class="dropdown-item text-center text-primary py-2">View all messages</a>';
    }
};

// Event listeners for mark as read buttons
document.addEventListener('DOMContentLoaded', function() {
    const markNotificationsBtn = document.querySelector('.notification-dropdown .dropdown-header a');
    const markMessagesBtn = document.querySelector('.messages-dropdown .dropdown-header a');
    
    markNotificationsBtn?.addEventListener('click', function(e) {
        e.preventDefault();
        NotificationManager.markAllNotificationsAsRead();
    });
    
    markMessagesBtn?.addEventListener('click', function(e) {
        e.preventDefault();
        NotificationManager.markAllMessagesAsRead();
    });
});
