<?php
/**
 * Session cleanup utility
 * Used to prevent redirect loops and fix authentication issues
 */

// First, start the session if it's not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Clear all session variables
$_SESSION = array();

// Delete the session cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $params["path"],
        $params["domain"],
        $params["secure"],
        $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Start a fresh session
session_start();

// Set a flag to indicate session was cleared
$_SESSION['session_cleared'] = true;
$_SESSION['session_cleared_time'] = time();

// If a redirect parameter was provided, redirect there after clearing the session
$redirect = isset($_GET['redirect']) ? $_GET['redirect'] : '../auth/login.php';

// Make sure the redirect is safe (prevent open redirects)
if (strpos($redirect, 'http') === 0 && strpos($redirect, 'localhost') === false) {
    // If it's an external URL, redirect to the home page instead
    $redirect = '../auth/login.php';
}

// Redirect to the login page or specified page
header("Location: $redirect");
exit;
?>
