<?php
/**
 * Generate referral codes for existing teachers who don't have them
 */

header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== CREATING MISSING REFERRAL CODES ===\n\n";

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error . "\n");
    }
    
    echo "✓ Database connected: $db_name\n\n";

    // Get all teachers AND students
    $usersQuery = "SELECT user_id, username, first_name, last_name, user_role FROM users WHERE user_role IN ('teacher', 'student')";
    $usersResult = $conn->query($usersQuery);
    
    if (!$usersResult || $usersResult->num_rows === 0) {
        echo "No teachers or students found in database\n";
        exit;
    }
    
    echo "Found {$usersResult->num_rows} users (teachers + students)\n\n";
    
    $createdCount = 0;
    
    while ($user = $usersResult->fetch_assoc()) {
        echo "Processing {$user['user_role']}: {$user['first_name']} {$user['last_name']} (ID: {$user['user_id']})\n";
        
        // Check if this user already has a referral code
        $existingQuery = "SELECT referral_code FROM referrals WHERE referrer_id = {$user['user_id']} AND referrer_type = '{$user['user_role']}'";
        $existingResult = $conn->query($existingQuery);
        
        if ($existingResult && $existingResult->num_rows > 0) {
            $existing = $existingResult->fetch_assoc();
            echo "  → Already has referral code: {$existing['referral_code']}\n";
            continue;
        }
        
        // Generate referral code based on user role
        $usernamePrefix = strtoupper(substr($user['username'], 0, 2));
        
        if ($user['user_role'] === 'teacher') {
            // Teacher pattern: TBN + first 2 letters of username + U + user_id (like TBNSU1480)
            $referralCode = 'TBN' . $usernamePrefix . 'U' . $user['user_id'];
        } else {
            // Student pattern: KABR + first 2 letters of username + user_id (like KABR1545)
            $referralCode = 'KABR' . $usernamePrefix . $user['user_id'];
            
            // Alternative student pattern if first doesn't work
            if (strlen($referralCode) > 10) {
                $referralCode = 'KABR' . $user['user_id'];
            }
        }
        
        echo "  → Generated code: $referralCode\n";
        
        // Insert referral code into referrals table
        $insertQuery = "INSERT INTO referrals (referrer_id, referrer_type, referral_code, status, created_at) VALUES (?, ?, ?, 'active', NOW())";
        $stmt = $conn->prepare($insertQuery);
        
        if ($stmt) {
            $stmt->bind_param("iss", $user['user_id'], $user['user_role'], $referralCode);
            
            if ($stmt->execute()) {
                echo "  ✓ Created referral code successfully\n";
                $createdCount++;
                
                // Test if this matches expected codes
                if ($referralCode === 'TBNSU1480') {
                    echo "  *** MATCH FOUND! This teacher generates TBNSU1480 ***\n";
                }
                if ($referralCode === 'KABR1545' || strpos($referralCode, 'KABR') === 0) {
                    echo "  *** Student referral code pattern matched! ***\n";
                }
            } else {
                echo "  ✗ Failed to create referral code: " . $stmt->error . "\n";
            }
        } else {
            echo "  ✗ Failed to prepare statement: " . $conn->error . "\n";
        }
        
        echo "\n";
    }
    
    echo "=== SUMMARY ===\n";
    echo "Referral codes created: $createdCount\n";
    
    // Test specific referral codes
    echo "\n=== TESTING SPECIFIC CODES ===\n";
    
    // Test TBNSU1480 (teacher code)
    echo "Testing TBNSU1480 (teacher code):\n";
    $testQuery1 = "SELECT r.referral_code, r.referrer_type, u.first_name, u.last_name, u.username 
                   FROM referrals r 
                   JOIN users u ON r.referrer_id = u.user_id 
                   WHERE r.referral_code = 'TBNSU1480'";
    $testResult1 = $conn->query($testQuery1);
    
    if ($testResult1 && $testResult1->num_rows > 0) {
        $match = $testResult1->fetch_assoc();
        echo "✓ TBNSU1480 exists! Referrer: {$match['first_name']} {$match['last_name']} ({$match['username']}) - {$match['referrer_type']}\n";
    } else {
        echo "✗ TBNSU1480 not found\n";
    }
    
    // Test KABR1545 (student code)
    echo "\nTesting KABR1545 (student code):\n";
    $testQuery2 = "SELECT r.referral_code, r.referrer_type, u.first_name, u.last_name, u.username 
                   FROM referrals r 
                   JOIN users u ON r.referrer_id = u.user_id 
                   WHERE r.referral_code = 'KABR1545'";
    $testResult2 = $conn->query($testQuery2);
    
    if ($testResult2 && $testResult2->num_rows > 0) {
        $match = $testResult2->fetch_assoc();
        echo "✓ KABR1545 exists! Referrer: {$match['first_name']} {$match['last_name']} ({$match['username']}) - {$match['referrer_type']}\n";
    } else {
        echo "✗ KABR1545 not found\n";
    }
    
    // Show sample generated codes for debugging
    echo "\n=== SAMPLE GENERATED CODES ===\n";
    echo "Teachers:\n";
    $teacherQuery = "SELECT r.referral_code, r.referrer_id, u.username FROM referrals r JOIN users u ON r.referrer_id = u.user_id WHERE r.referrer_type = 'teacher' LIMIT 5";
    $teacherResult = $conn->query($teacherQuery);
    while ($row = $teacherResult->fetch_assoc()) {
        echo "  {$row['referral_code']} → {$row['username']} (ID: {$row['referrer_id']})\n";
    }
    
    echo "\nStudents:\n";
    $studentQuery = "SELECT r.referral_code, r.referrer_id, u.username FROM referrals r JOIN users u ON r.referrer_id = u.user_id WHERE r.referrer_type = 'student' LIMIT 5";
    $studentResult = $conn->query($studentQuery);
    while ($row = $studentResult->fetch_assoc()) {
        echo "  {$row['referral_code']} → {$row['username']} (ID: {$row['referrer_id']})\n";
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
