<?php
/**
 * Debug script to check why ALKI2387 referral code is failing
 */

header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== DEBUGGING REFERRAL CODE: ALKI2387 ===\n\n";

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error . "\n");
    }
    
    echo "✓ Database connected: $db_name\n\n";

    $testCode = 'ALKI2387';
    
    // Test 1: Direct lookup in referrals table
    echo "=== TEST 1: DIRECT LOOKUP IN REFERRALS TABLE ===\n";
    $directQuery = "SELECT * FROM referrals WHERE referral_code = '$testCode'";
    $directResult = $conn->query($directQuery);
    
    if ($directResult && $directResult->num_rows > 0) {
        $referral = $directResult->fetch_assoc();
        echo "✓ FOUND in referrals table:\n";
        foreach ($referral as $key => $value) {
            echo "  $key: $value\n";
        }
    } else {
        echo "✗ NOT FOUND in referrals table\n";
    }
    
    // Test 2: Search for similar codes
    echo "\n=== TEST 2: SEARCHING FOR SIMILAR CODES ===\n";
    $similarQuery = "SELECT referral_code FROM referrals WHERE referral_code LIKE '%ALKI%' OR referral_code LIKE '%2387%'";
    $similarResult = $conn->query($similarQuery);
    
    if ($similarResult && $similarResult->num_rows > 0) {
        echo "Similar codes found:\n";
        while ($row = $similarResult->fetch_assoc()) {
            echo "  {$row['referral_code']}\n";
        }
    } else {
        echo "No similar codes found\n";
    }
    
    // Test 3: Check what pattern ALKI2387 should match
    echo "\n=== TEST 3: ANALYZING PATTERN ===\n";
    echo "Code: $testCode\n";
    echo "Length: " . strlen($testCode) . "\n";
    echo "Pattern analysis:\n";
    
    if (strpos($testCode, 'TBN') === 0) {
        echo "  → Teacher pattern (TBN...)\n";
        $prefix = substr($testCode, 3, 2); // Get username prefix
        $suffix = substr($testCode, 6); // Get user ID part
        echo "  → Username prefix: $prefix\n";
        echo "  → User ID part: $suffix\n";
    } elseif (strpos($testCode, 'KABR') === 0) {
        echo "  → Student pattern (KABR...)\n";
        $prefix = substr($testCode, 4, 2); // Get username prefix
        $suffix = substr($testCode, 6); // Get user ID part
        echo "  → Username prefix: $prefix\n";
        echo "  → User ID part: $suffix\n";
    } else {
        echo "  → Unknown pattern - doesn't match TBN or KABR\n";
        echo "  → First 4 chars: " . substr($testCode, 0, 4) . "\n";
        echo "  → This might be a different naming convention\n";
    }
    
    // Test 4: Check users with username containing "alki"
    echo "\n=== TEST 4: CHECKING USERS WITH 'ALKI' IN USERNAME ===\n";
    $userQuery = "SELECT user_id, username, user_role, first_name, last_name FROM users WHERE username LIKE '%alki%'";
    $userResult = $conn->query($userQuery);
    
    if ($userResult && $userResult->num_rows > 0) {
        echo "Users with 'alki' in username:\n";
        while ($user = $userResult->fetch_assoc()) {
            echo "  {$user['user_role']}: {$user['first_name']} {$user['last_name']} ({$user['username']}) - ID: {$user['user_id']}\n";
            
            // Generate what their referral code should be
            $usernamePrefix = strtoupper(substr($user['username'], 0, 2));
            if ($user['user_role'] === 'teacher') {
                $expectedCode = 'TBN' . $usernamePrefix . 'U' . $user['user_id'];
            } else {
                $expectedCode = 'KABR' . $usernamePrefix . $user['user_id'];
            }
            echo "    → Expected referral code: $expectedCode\n";
        }
    } else {
        echo "No users found with 'alki' in username\n";
    }
    
    // Test 5: Check user ID 2387
    echo "\n=== TEST 5: CHECKING USER ID 2387 ===\n";
    $userIdQuery = "SELECT user_id, username, user_role, first_name, last_name FROM users WHERE user_id = 2387";
    $userIdResult = $conn->query($userIdQuery);
    
    if ($userIdResult && $userIdResult->num_rows > 0) {
        $user = $userIdResult->fetch_assoc();
        echo "User ID 2387 found:\n";
        echo "  {$user['user_role']}: {$user['first_name']} {$user['last_name']} ({$user['username']})\n";
        
        // Generate what their referral code should be
        $usernamePrefix = strtoupper(substr($user['username'], 0, 2));
        if ($user['user_role'] === 'teacher') {
            $expectedCode = 'TBN' . $usernamePrefix . 'U' . $user['user_id'];
        } else {
            $expectedCode = 'KABR' . $usernamePrefix . $user['user_id'];
        }
        echo "  → Expected referral code: $expectedCode\n";
        
        // Check if they have a referral code
        $refQuery = "SELECT referral_code FROM referrals WHERE referrer_id = 2387";
        $refResult = $conn->query($refQuery);
        if ($refResult && $refResult->num_rows > 0) {
            $ref = $refResult->fetch_assoc();
            echo "  → Actual referral code: {$ref['referral_code']}\n";
        } else {
            echo "  → No referral code found for this user\n";
        }
    } else {
        echo "User ID 2387 not found\n";
    }
    
    // Test 6: Test validation endpoint
    echo "\n=== TEST 6: TESTING VALIDATION ENDPOINT ===\n";
    echo "Testing what the validation endpoint returns for ALKI2387...\n";
    
    // Simulate the validation logic
    $validationQuery = "SELECT u.user_id, u.username, u.user_role, u.first_name, u.last_name
                        FROM referrals r 
                        JOIN users u ON r.referrer_id = u.user_id 
                        WHERE r.referral_code = '$testCode'";
    
    $validationResult = $conn->query($validationQuery);
    
    if ($validationResult && $validationResult->num_rows > 0) {
        $referrer = $validationResult->fetch_assoc();
        echo "✓ Validation would succeed:\n";
        echo "  Referrer: {$referrer['first_name']} {$referrer['last_name']} ({$referrer['username']})\n";
        echo "  Role: {$referrer['user_role']}\n";
    } else {
        echo "✗ Validation would fail - code not found\n";
    }
    
    // Test 7: Show recent referral codes for comparison
    echo "\n=== TEST 7: RECENT REFERRAL CODES FOR COMPARISON ===\n";
    $recentQuery = "SELECT referral_code, referrer_type FROM referrals ORDER BY created_at DESC LIMIT 10";
    $recentResult = $conn->query($recentQuery);
    
    if ($recentResult && $recentResult->num_rows > 0) {
        echo "Recent referral codes:\n";
        while ($row = $recentResult->fetch_assoc()) {
            echo "  {$row['referral_code']} ({$row['referrer_type']})\n";
        }
    }
    
    echo "\n=== CONCLUSION ===\n";
    echo "If ALKI2387 should be valid, either:\n";
    echo "1. The user exists but doesn't have a referral code generated yet\n";
    echo "2. The code follows a different pattern than we implemented\n";
    echo "3. There's a typo in the expected code\n";
    echo "4. The validation endpoint has an issue\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
