<?php
/**
 * Debug version of referral validation - shows detailed information
 */

header('Content-Type: application/json');

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
        exit;
    }

    $input = json_decode(file_get_contents('php://input'), true);
    $referralCode = isset($input['code']) ? trim($input['code']) : 'KABR1545';

    $debug = [
        'searching_for' => $referralCode,
        'database' => $db_name,
        'environment' => $is_local ? 'local' : 'production'
    ];

    // Check if referral_codes table exists
    $tableCheck = $conn->query("SHOW TABLES LIKE 'referral_codes'");
    $debug['referral_codes_table_exists'] = $tableCheck->num_rows > 0;

    if ($tableCheck->num_rows === 0) {
        // Check what tables DO exist
        $allTables = $conn->query("SHOW TABLES");
        $tables = [];
        while ($row = $allTables->fetch_array()) {
            $tables[] = $row[0];
        }
        $debug['available_tables'] = $tables;
        echo json_encode($debug);
        exit;
    }

    // Show table structure
    $structure = $conn->query("DESCRIBE referral_codes");
    $columns = [];
    while ($row = $structure->fetch_assoc()) {
        $columns[] = $row['Field'];
    }
    $debug['referral_codes_columns'] = $columns;

    // Search for the exact code
    $exactQuery = "SELECT * FROM referral_codes WHERE code = ?";
    $stmt = $conn->prepare($exactQuery);
    $stmt->bind_param("s", $referralCode);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $debug['exact_match'] = $result->fetch_assoc();
    } else {
        $debug['exact_match'] = null;
        
        // Search for similar codes
        $likeQuery = "SELECT code FROM referral_codes WHERE code LIKE ?";
        $likeStmt = $conn->prepare($likeQuery);
        $likePattern = '%' . $referralCode . '%';
        $likeStmt->bind_param("s", $likePattern);
        $likeStmt->execute();
        $likeResult = $likeStmt->get_result();
        
        $similar = [];
        while ($row = $likeResult->fetch_assoc()) {
            $similar[] = $row['code'];
        }
        $debug['similar_codes'] = $similar;
        
        // Show all codes that start with 'KABR'
        $kabrQuery = "SELECT code, user_id FROM referral_codes WHERE code LIKE 'KABR%' LIMIT 10";
        $kabrResult = $conn->query($kabrQuery);
        $kabrCodes = [];
        while ($row = $kabrResult->fetch_assoc()) {
            $kabrCodes[] = $row;
        }
        $debug['kabr_codes'] = $kabrCodes;
    }

    // Check users table
    $usersCheck = $conn->query("SHOW TABLES LIKE 'users'");
    $debug['users_table_exists'] = $usersCheck->num_rows > 0;

    if ($usersCheck->num_rows > 0) {
        // Show users structure
        $userStructure = $conn->query("DESCRIBE users");
        $userColumns = [];
        while ($row = $userStructure->fetch_assoc()) {
            $userColumns[] = $row['Field'];
        }
        $debug['users_columns'] = $userColumns;
    }

    echo json_encode($debug);

} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
