<?php
/**
 * Debug validation endpoint to see exact errors
 */

header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== DEBUGGING VALIDATION ENDPOINT ===\n\n";

// Test 1: Check if validation endpoint file exists and is readable
$validationFile = __DIR__ . '/validate_referral.php';
echo "Validation file path: $validationFile\n";
echo "File exists: " . (file_exists($validationFile) ? "YES" : "NO") . "\n";
echo "File readable: " . (is_readable($validationFile) ? "YES" : "NO") . "\n\n";

// Test 2: Try to include and run validation endpoint directly
echo "=== TESTING VALIDATION ENDPOINT DIRECTLY ===\n";

// Simulate POST request
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST = [];

// Simulate JSON input
$testCode = 'ALKI2315';
$jsonInput = json_encode(['code' => $testCode]);
file_put_contents('php://memory', $jsonInput);

echo "Simulating POST request with code: $testCode\n";
echo "JSON input: $jsonInput\n\n";

// Capture output and errors
ob_start();
$errorOutput = '';

// Redirect stderr to capture PHP errors
if (function_exists('error_get_last')) {
    $oldErrorHandler = set_error_handler(function($errno, $errstr, $errfile, $errline) use (&$errorOutput) {
        $errorOutput .= "PHP Error: $errstr in $errfile on line $errline\n";
    });
}

try {
    // Create a temporary file with JSON input for testing
    $tempFile = tempnam(sys_get_temp_dir(), 'json_input');
    file_put_contents($tempFile, $jsonInput);
    
    // Mock php://input
    $old_input = ini_get('auto_prepend_file');
    
    echo "Starting validation endpoint execution...\n";
    
    // Include the validation file
    include $validationFile;
    
} catch (Exception $e) {
    echo "Exception caught: " . $e->getMessage() . "\n";
} catch (ParseError $e) {
    echo "Parse Error: " . $e->getMessage() . "\n";
} catch (Error $e) {
    echo "Fatal Error: " . $e->getMessage() . "\n";
}

$output = ob_get_contents();
ob_end_clean();

echo "Output from validation endpoint:\n";
echo "================================\n";
echo $output;
echo "\n================================\n";

if (!empty($errorOutput)) {
    echo "Error Output:\n";
    echo "============\n";
    echo $errorOutput;
    echo "\n============\n";
}

// Test 3: Check what the student dashboard is actually generating
echo "\n=== CHECKING STUDENT DASHBOARD CODE GENERATION ===\n";

// Database connection
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    // Find user with ID that would generate ALKI2315
    // Pattern seems to be: first 4 letters of username/name + user_id
    
    echo "Looking for users that could generate ALKI2315...\n";
    
    // Check for user ID 2315
    $userQuery = "SELECT user_id, username, first_name, last_name, user_role FROM users WHERE user_id = 2315";
    $result = $conn->query($userQuery);
    
    if ($result && $result->num_rows > 0) {
        $user = $result->fetch_assoc();
        echo "Found user ID 2315:\n";
        echo "  Name: {$user['first_name']} {$user['last_name']}\n";
        echo "  Username: {$user['username']}\n";
        echo "  Role: {$user['user_role']}\n";
        
        // Generate possible patterns
        $patterns = [
            strtoupper(substr($user['first_name'], 0, 2) . substr($user['last_name'], 0, 2)) . $user['user_id'], // ALMA2315
            strtoupper(substr($user['username'], 0, 4)) . $user['user_id'], // ALKI2315 if username starts with alki
            strtoupper(substr($user['first_name'], 0, 4)) . $user['user_id'], // ALIC2315 if first name is Alice
        ];
        
        echo "  Possible referral code patterns:\n";
        foreach ($patterns as $pattern) {
            echo "    → $pattern\n";
            if ($pattern === 'ALKI2315') {
                echo "      *** MATCH FOUND! ***\n";
            }
        }
    } else {
        echo "User ID 2315 not found\n";
    }
    
    // Check what referral codes this user actually has
    $refQuery = "SELECT referral_code FROM referrals WHERE referrer_id = 2315";
    $refResult = $conn->query($refQuery);
    
    if ($refResult && $refResult->num_rows > 0) {
        echo "  Stored referral codes:\n";
        while ($row = $refResult->fetch_assoc()) {
            echo "    → {$row['referral_code']}\n";
        }
    } else {
        echo "  No stored referral codes found\n";
    }

} catch (Exception $e) {
    echo "Database error: " . $e->getMessage() . "\n";
}
?>
