<?php
/**
 * Simple POST Test - Panadite Academy
 * Test if form submissions are working properly
 */

// Start enhanced session configuration (same as login.php)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Enhanced session configuration matching login.php
if (session_status() !== PHP_SESSION_ACTIVE) {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    // Adjust secure flag based on HTTPS availability
    ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 1 : 0);
    ini_set('session.cookie_samesite', 'Lax');
    ini_set('session.use_strict_mode', 1);
    ini_set('session.cookie_lifetime', 7200); // 2 hours
    ini_set('session.gc_maxlifetime', 7200); // 2 hours
    ini_set('session.cookie_domain', ''); // Let PHP determine the domain
    ini_set('session.cookie_path', '/'); // Ensure cookie works for entire site

    // Set proper session save path for Linux server (same as login.php)
    $temp_dir = sys_get_temp_dir();
    if (!is_writable($temp_dir)) {
        // Try alternative paths for Linux server
        $alternative_paths = ['/tmp', '/var/tmp', dirname(__FILE__) . '/tmp'];
        foreach ($alternative_paths as $path) {
            if (is_dir($path) && is_writable($path)) {
                $temp_dir = $path;
                break;
            }
        }
    }
    ini_set('session.save_path', $temp_dir);
    error_log('POST_TEST - Session save path set to: ' . $temp_dir);
    
    // Start session
    session_start();
}

// Log all requests
error_log('POST_TEST - Request method: ' . ($_SERVER['REQUEST_METHOD'] ?? 'unknown'));
error_log('POST_TEST - POST data: ' . print_r($_POST, true));
error_log('POST_TEST - GET data: ' . print_r($_GET, true));

?>
<!DOCTYPE html>
<html>
<head>
    <title>POST Test - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4>🧪 POST Form Submission Test</h4>
                </div>
                <div class="card-body">
                    
                    <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
                        <div class="alert alert-success">
                            <h5>✅ POST Request Successful!</h5>
                            <p><strong>Method:</strong> <?php echo $_SERVER['REQUEST_METHOD']; ?></p>
                            <p><strong>Username:</strong> <?php echo htmlspecialchars($_POST['username'] ?? 'not set'); ?></p>
                            <p><strong>Password:</strong> <?php echo htmlspecialchars($_POST['password'] ?? 'not set'); ?></p>
                            <p><strong>Server Time:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>
                            
                            <hr>
                            <h6>Now test emergency login logic:</h6>
                            <?php
                            $username = trim($_POST['username'] ?? '');
                            $password = trim($_POST['password'] ?? '');
                            
                            if (($username === 'admin' && $password === 'admin123') || 
                                ($username === 'teacher' && $password === 'teacher123') || 
                                ($username === 'student' && $password === 'student123')) {
                                echo '<div class="alert alert-success">✅ Emergency credentials VALID</div>';
                                
                                // Test session creation
                                $_SESSION['test_user'] = $username;
                                $_SESSION['test_time'] = time();
                                session_write_close();
                                session_start();
                                
                                echo '<p><strong>Session Test:</strong> ' . (isset($_SESSION['test_user']) ? '✅ Working' : '❌ Failed') . '</p>';
                                echo '<p><strong>Session ID:</strong> ' . session_id() . '</p>';
                                echo '<p><strong>Cookie Params:</strong> ' . print_r(session_get_cookie_params(), true) . '</p>';
                                
                            } else {
                                echo '<div class="alert alert-danger">❌ Emergency credentials INVALID</div>';
                            }
                            ?>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <h5>📋 Form Ready</h5>
                            <p>This will test if POST form submissions work properly.</p>
                            <p><strong>Current Method:</strong> <?php echo $_SERVER['REQUEST_METHOD']; ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                        <div class="mb-3">
                            <label class="form-label">Username:</label>
                            <input type="text" name="username" class="form-control" value="student" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Password:</label>
                            <input type="text" name="password" class="form-control" value="student123" required>
                        </div>
                        <button type="submit" class="btn btn-primary">🧪 Test POST Submission</button>
                    </form>
                    
                    <hr>
                    <h6>🔍 Debug Information:</h6>
                    <ul>
                        <li><strong>Server:</strong> <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></li>
                        <li><strong>PHP Version:</strong> <?php echo PHP_VERSION; ?></li>
                        <li><strong>Session Status:</strong> <?php echo session_status(); ?>
                            <?php if (session_status() === PHP_SESSION_ACTIVE) echo ' (ACTIVE)'; ?>
                        </li>
                        <li><strong>Headers Sent:</strong> <?php echo headers_sent() ? 'YES' : 'NO'; ?></li>
                    </ul>
                    
                    <p class="mt-3">
                        <a href="login.php" class="btn btn-secondary">← Back to Login</a>
                        <a href="login_debug.php" class="btn btn-info">View Full Debug</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
