<?php
/**
 * Simple referral code search with error display
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: text/plain');

echo "=== REFERRAL CODE SEARCH ===\n";
echo "Searching for: TBNSU1480\n\n";

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

echo "Database: $db_name\n";
echo "Environment: " . ($is_local ? 'local' : 'production') . "\n\n";

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error . "\n");
    }
    
    echo "✓ Database connected successfully\n\n";

    $searchCode = 'TBNSU1480';

    // 1. Check users table for referral codes
    echo "=== CHECKING USERS TABLE ===\n";
    $usersQuery = $conn->query("DESCRIBE users");
    echo "Users table columns:\n";
    $userColumns = [];
    while ($col = $usersQuery->fetch_assoc()) {
        echo "- {$col['Field']}\n";
        $userColumns[] = $col['Field'];
    }

    // Check if users have referral_code column
    if (in_array('referral_code', $userColumns)) {
        echo "\n✓ Found referral_code column in users table\n";
        $userReferralQuery = "SELECT id, username, role, referral_code FROM users WHERE referral_code = '$searchCode'";
        $result = $conn->query($userReferralQuery);
        if ($result->num_rows > 0) {
            echo "FOUND IT! Referral code exists in users table:\n";
            while ($row = $result->fetch_assoc()) {
                echo "ID: {$row['id']}, Username: {$row['username']}, Role: {$row['role']}, Code: {$row['referral_code']}\n";
            }
        } else {
            echo "Not found in users.referral_code\n";
        }
    }

    // 2. Check referrals table
    echo "\n=== CHECKING REFERRALS TABLE ===\n";
    $referralsCheck = $conn->query("SHOW TABLES LIKE 'referrals'");
    if ($referralsCheck->num_rows > 0) {
        echo "✓ Referrals table exists\n";
        $referralsQuery = $conn->query("DESCRIBE referrals");
        echo "Referrals table columns:\n";
        while ($col = $referralsQuery->fetch_assoc()) {
            echo "- {$col['Field']}\n";
        }

        // Check for the code in referrals table
        $referralSearch = "SELECT * FROM referrals WHERE referral_code = '$searchCode' OR code = '$searchCode' OR referrer_code = '$searchCode'";
        $result = $conn->query($referralSearch);
        if ($result && $result->num_rows > 0) {
            echo "FOUND IT! In referrals table:\n";
            while ($row = $result->fetch_assoc()) {
                print_r($row);
            }
        }
    } else {
        echo "✗ Referrals table does not exist\n";
    }

    // 3. Check if it's generated dynamically from user data
    echo "\n=== CHECKING FOR DYNAMIC GENERATION ===\n";
    $teacherQuery = "SELECT id, username, role FROM users WHERE role = 'teacher' AND username LIKE '%SU%'";
    $teacherResult = $conn->query($teacherQuery);
    echo "Teachers with 'SU' in username:\n";
    while ($row = $teacherResult->fetch_assoc()) {
        // Try to generate code like TBNSU1480
        $generatedCode = 'TBN' . strtoupper(substr($row['username'], 0, 2)) . $row['id'];
        echo "User ID: {$row['id']}, Username: {$row['username']}, Generated Code: $generatedCode\n";
        if ($generatedCode === $searchCode) {
            echo "*** MATCH FOUND! This code is generated from user data! ***\n";
        }
    }

    // 4. Search all tables containing 'referral' in name
    echo "\n=== CHECKING ALL REFERRAL TABLES ===\n";
    $allTables = $conn->query("SHOW TABLES");
    while ($table = $allTables->fetch_array()) {
        $tableName = $table[0];
        if (stripos($tableName, 'referral') !== false) {
            echo "Checking table: $tableName\n";
            $tableQuery = "SELECT * FROM `$tableName` LIMIT 2";
            $tableResult = $conn->query($tableQuery);
            if ($tableResult && $tableResult->num_rows > 0) {
                echo "Sample data:\n";
                while ($row = $tableResult->fetch_assoc()) {
                    foreach ($row as $key => $value) {
                        echo "  $key: $value\n";
                    }
                    echo "  ---\n";
                }
            }
            echo "\n";
        }
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
