<?php
/**
 * Test the validation endpoint with known working referral codes
 */

header('Content-Type: text/html');
echo "<h2>Testing Referral Code Validation Endpoint</h2>";

// Test codes we know should exist
$testCodes = ['KABR1510', 'TBNSU1480', 'KABRKE23'];

foreach ($testCodes as $code) {
    echo "<h3>Testing: $code</h3>";
    
    // Prepare the POST data
    $postData = json_encode(['code' => $code]);
    
    // Set up the context for the POST request
    $context = stream_context_create([
        'http' => [
            'method' => 'POST',
            'header' => [
                'Content-Type: application/json',
                'Content-Length: ' . strlen($postData)
            ],
            'content' => $postData
        ]
    ]);
    
    // Make the request
    $url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/validate_referral.php';
    $result = file_get_contents($url, false, $context);
    
    echo "<strong>Request URL:</strong> $url<br>";
    echo "<strong>POST Data:</strong> $postData<br>";
    echo "<strong>Response:</strong> <pre>$result</pre>";
    
    // Try to decode the JSON response
    $decoded = json_decode($result, true);
    if ($decoded) {
        echo "<strong>Decoded Response:</strong><br>";
        echo "Success: " . ($decoded['success'] ? 'true' : 'false') . "<br>";
        echo "Message: " . ($decoded['message'] ?? 'N/A') . "<br>";
        if (isset($decoded['referrer'])) {
            echo "Referrer: " . $decoded['referrer']['name'] . " (" . $decoded['referrer']['role'] . ")<br>";
        }
    } else {
        echo "<strong>⚠️ Could not decode JSON response</strong><br>";
    }
    
    echo "<hr>";
}

echo "<h3>JavaScript Test</h3>";
echo "<p>Test referral validation with the actual JavaScript used in the form:</p>";
echo "<input type='text' id='test-referral' placeholder='Enter referral code (e.g., KABR1510)' style='padding: 10px; width: 200px;'>";
echo "<button onclick='testReferralJS()' style='padding: 10px; margin-left: 10px;'>Test</button>";
echo "<div id='test-result' style='margin-top: 10px; padding: 10px; border: 1px solid #ccc;'></div>";

echo "<script>
function testReferralJS() {
    const code = document.getElementById('test-referral').value;
    const resultDiv = document.getElementById('test-result');
    
    if (!code) {
        resultDiv.innerHTML = 'Please enter a referral code';
        return;
    }
    
    resultDiv.innerHTML = 'Testing...';
    
    fetch('validate_referral.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            code: code.trim()
        })
    })
    .then(response => response.text())
    .then(text => {
        console.log('Raw response:', text);
        try {
            const data = JSON.parse(text);
            if (data.success) {
                resultDiv.innerHTML = '<strong>✅ SUCCESS!</strong><br>Referrer: ' + data.referrer.name + ' (' + data.referrer.role + ')';
                resultDiv.style.backgroundColor = '#d4edda';
            } else {
                resultDiv.innerHTML = '<strong>❌ FAILED:</strong> ' + data.message;
                resultDiv.style.backgroundColor = '#f8d7da';
            }
        } catch (e) {
            resultDiv.innerHTML = '<strong>⚠️ JSON Parse Error:</strong><br><pre>' + text + '</pre>';
            resultDiv.style.backgroundColor = '#fff3cd';
        }
    })
    .catch(error => {
        resultDiv.innerHTML = '<strong>🔥 Network Error:</strong> ' + error.message;
        resultDiv.style.backgroundColor = '#f8d7da';
        console.error('Error:', error);
    });
}
</script>";
?>
