<?php
require_once 'functions.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unauthorized Access - Panadite Academy</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/Panadite academy/assets/css/style.css">
    <style>
        .error-container {
            max-width: 600px;
            margin: 100px auto;
            text-align: center;
            padding: 40px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .error-icon {
            font-size: 80px;
            color: #FFA915;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="error-container">
            <div class="error-icon">
                <i class="fas fa-exclamation-circle"></i>
            </div>
            <h1>Unauthorized Access</h1>
            <p class="lead mb-4">Sorry, you don't have permission to access this page.</p>
            
            <?php if (!isLoggedIn()): ?>
                <p>Please log in to continue.</p>
                <a href="/Panadite academy/auth/login.php" class="btn btn-primary me-2">Login</a>
                <a href="/Panadite academy/auth/register.php" class="btn btn-outline-primary">Register</a>
            <?php else: ?>
                <p>Please return to an authorized area.</p>
                <?php if ($_SESSION['user_role'] === 'admin'): ?>
                    <a href="/Panadite academy/admin/dashboard.php" class="btn btn-primary">Go to Admin Dashboard</a>
                <?php elseif ($_SESSION['user_role'] === 'teacher'): ?>
                    <a href="/Panadite academy/teacher/dashboard.php" class="btn btn-primary">Go to Teacher Dashboard</a>
                <?php else: ?>
                    <a href="/Panadite academy/student/dashboard.php" class="btn btn-primary">Go to Student Dashboard</a>
                <?php endif; ?>
            <?php endif; ?>

            <div class="mt-4">
                <a href="/Panadite academy/index.php" class="link-secondary">
                    <i class="fas fa-home me-1"></i> Return to Home
                </a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
