<?php
session_start();
require_once 'includes/config.php';

// Get current user if logged in
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];
    $user_query = "SELECT * FROM users WHERE user_id = '$user_id'";
    $user_result = mysqli_query($conn, $user_query);
    $current_user = mysqli_fetch_assoc($user_result);
}

// Function to adjust color brightness
function adjustBrightness($hex, $steps) {
    // Convert hex to RGB
    $hex = str_replace('#', '', $hex);
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));

    // Adjust brightness
    $r = max(0, min(255, $r + $steps));
    $g = max(0, min(255, $g + $steps));
    $b = max(0, min(255, $b + $steps));

    // Convert back to hex
    return '#' . sprintf('%02x%02x%02x', $r, $g, $b);
}

// Get the category parameter
$category_slug = isset($_GET['cat']) ? $_GET['cat'] : '';

// Define our categories structure
$categories = [
    'office-productivity' => [
        'id' => 1,
        'name' => 'End-User Computing & Office Productivity',
        'icon' => 'fa-desktop',
        'description' => 'Master essential computer skills and office applications for professional success.',
        'color' => '#3498db'
    ],
    'programming' => [
        'id' => 2,
        'name' => 'Programming & Software Development',
        'icon' => 'fa-code',
        'description' => 'Learn to code and develop software applications with industry-standard programming languages and techniques.',
        'color' => '#2ecc71'
    ],
    'web-development' => [
        'id' => 3,
        'name' => 'Web & Front-End Development',
        'icon' => 'fa-laptop-code',
        'description' => 'Create modern, responsive websites and web applications using the latest front-end technologies.',
        'color' => '#e74c3c'
    ],
    'data-analysis' => [
        'id' => 4,
        'name' => 'Data Analysis & Business Intelligence',
        'icon' => 'fa-chart-bar',
        'description' => 'Transform raw data into meaningful insights and visualizations for informed business decisions.',
        'color' => '#9b59b6'
    ],
    'it-support' => [
        'id' => 5,
        'name' => 'IT Support & Infrastructure',
        'icon' => 'fa-network-wired',
        'description' => 'Learn to manage, troubleshoot, and maintain IT systems and networks.',
        'color' => '#f39c12'
    ]
];

// Check if the category exists
$current_category = null;
if (!empty($category_slug) && isset($categories[$category_slug])) {
    $current_category = $categories[$category_slug];
    
    // Get courses for this category
    $cat_id = $current_category['id'];
    
    // Fetch the courses with the actual field names from the database
    $course_query = "DESCRIBE courses";
    $describe_result = mysqli_query($conn, $course_query);
    $field_names = [];
    
    // Collect actual field names from the database
    if ($describe_result) {
        while ($row = mysqli_fetch_assoc($describe_result)) {
            $field_names[] = $row['Field'];
        }
    }
    
    // Now query the courses based on category
    $course_query = "SELECT c.*, 
                    (SELECT COUNT(*) FROM enrollments WHERE course_id = c.course_id) AS student_count 
                    FROM courses c 
                    WHERE c.category_id = '$cat_id' 
                    ORDER BY c.course_id DESC";
    $course_result = mysqli_query($conn, $course_query);
}

// SEO and meta info
$page_title = $current_category ? $current_category['name'] . ' Courses' : 'All Categories';
$meta_description = $current_category ? 'Explore our ' . $current_category['name'] . ' courses at Panadite Academy.' : 'Explore all course categories offered by Panadite Academy.';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> | Panadite Academy</title>
    <meta name="description" content="<?php echo $meta_description; ?>">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="/assets/images/favicon.ico" type="image/x-icon">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="/assets/css/style.css">
    
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <style>
        /* Modern color variables */
        :root {
            --primary-color: #4361ee;
            --primary-dark: #3a0ca3;
            --primary-light: #4cc9f0;
            --text-light: #ffffff;
            --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            --transition-speed: 0.4s;
        }
        
        /* Enhanced Category Header */
        .category-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: var(--text-light);
            padding: 4rem 0;
            position: relative;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 3rem;
        }
        
        .category-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 60%);
            animation: pulse 15s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.05); opacity: 0.8; }
            100% { transform: scale(1); opacity: 0.5; }
        }
        
        .category-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 20px;
            margin-bottom: 1.5rem;
            font-size: 2.2rem;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all var(--transition-speed);
            animation: fadeInDown 0.8s ease-out;
        }
        
        .category-icon:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
        }
        
        @keyframes fadeInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Modern Course Cards */
        .course-card {
            transition: var(--transition-speed);
            border: none;
            box-shadow: var(--card-shadow);
            border-radius: 16px;
            overflow: hidden;
            height: 100%;
            background: white;
            position: relative;
        }
        
        .course-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        }
        
        .course-image {
            height: 200px;
            object-fit: cover;
            transition: transform 0.8s ease;
        }
        
        .course-card:hover .course-image {
            transform: scale(1.05);
        }
        
        .course-badge {
            position: absolute;
            bottom: 15px;
            left: 15px;
            padding: 8px 16px;
            border-radius: 50px;
            font-size: 12px;
            font-weight: 600;
            letter-spacing: 0.5px;
            z-index: 2;
            background-color: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: var(--transition-speed);
        }
        
        .course-card:hover .course-badge {
            transform: translateY(-3px);
        }
        
        .module-list {
            font-size: 0.85rem;
            color: #666;
            margin: 15px 0;
            padding-left: 20px;
        }
        
        .module-list li {
            margin-bottom: 5px;
        }
        
        .course-meta {
            display: flex;
            justify-content: space-between;
            font-size: 0.85rem;
            padding-top: 15px;
            border-top: 1px solid rgba(0,0,0,0.05);
            color: #666;
        }
        
        .course-meta span {
            display: flex;
            align-items: center;
        }
        
        .course-meta i {
            margin-right: 5px;
            color: <?php echo $current_category ? $current_category['color'] : '#276BE4'; ?>;
        }
        
        .all-categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
        }
        
        /* Modern Category Cards */
        .category-card {
            border-radius: 16px;
            overflow: hidden;
            box-shadow: var(--card-shadow);
            transition: var(--transition-speed);
            height: 100%;
            background: white;
        }
        
        .category-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        }
        
        .category-card-header {
            color: white;
            padding: 2rem;
            position: relative;
            overflow: hidden;
            z-index: 1;
        }
        
        .category-card-header::before {
            content: '';
            position: absolute;
            top: -50px;
            right: -50px;
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            z-index: -1;
        }
        
        .category-card-header::after {
            content: '';
            position: absolute;
            bottom: -30px;
            left: -30px;
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.15);
            z-index: -1;
        }
        
        .category-card-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 16px;
            margin-bottom: 1.25rem;
            font-size: 1.5rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-5px); }
            100% { transform: translateY(0px); }
        }
        
        .category-card-body {
            padding: 2rem;
            background-color: white;
        }
        
        /* Modern Breadcrumb Navigation */
        .breadcrumb {
            background-color: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            padding: 0.8rem 1.5rem;
            border-radius: 50px;
            margin-bottom: 2rem;
            display: inline-flex;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            animation: fadeIn 1s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.9);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-speed);
        }
        
        .breadcrumb-item a:hover {
            color: white;
            text-shadow: 0 0 10px rgba(255, 255, 255, 0.5);
        }
        
        .breadcrumb-item.active {
            color: white;
            font-weight: 600;
        }
        
        .breadcrumb-item + .breadcrumb-item::before {
            color: rgba(255, 255, 255, 0.6);
        }
        
        /* Enhanced Back-to-top Button */
        .back-to-top {
            position: fixed;
            bottom: 25px;
            right: 25px;
            width: 50px;
            height: 50px;
            border-radius: 15px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition-speed);
            z-index: 999;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .back-to-top.active {
            opacity: 1;
            visibility: visible;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(67, 97, 238, 0.6); }
            70% { box-shadow: 0 0 0 15px rgba(67, 97, 238, 0); }
            100% { box-shadow: 0 0 0 0 rgba(67, 97, 238, 0); }
        }
        
        .back-to-top:hover {
            transform: translateY(-5px) scale(1.05);
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .category-header {
                padding: 40px 0;
            }
            
            .category-icon {
                font-size: 48px;
            }
            
            h1 {
                font-size: 2rem;
            }
        }
        
        /* Section heading */
        .section-heading {
            position: relative;
            margin-bottom: 30px;
            font-weight: 700;
        }
        
        .section-heading:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 50px;
            height: 3px;
            background: <?php echo $current_category ? $current_category['color'] : '#276BE4'; ?>;
        }
    </style>
</head>
<body>
    <!-- Include the navbar -->
    <?php include 'includes/navbar.php'; ?>
    
    <?php if ($current_category): ?>
    <!-- Category Header -->
    <header class="category-header">
        <div class="container">
            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="categories.php">Categories</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $current_category['name']; ?></li>
                </ol>
            </nav>
            
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="category-icon">
                        <i class="fas <?php echo $current_category['icon']; ?>"></i>
                    </div>
                    <h1 class="display-4 fw-bold mb-3"><?php echo $current_category['name']; ?></h1>
                    <p class="lead mb-0"><?php echo $current_category['description']; ?></p>
                </div>
                <div class="col-lg-4 d-none d-lg-block">
                    <!-- Decorative element -->
                    <div class="text-end">
                        <svg width="200" height="200" viewBox="0 0 200 200" fill="none" xmlns="http://www.w3.org/2000/svg" style="opacity: 0.2;">
                            <circle cx="100" cy="100" r="80" stroke="white" stroke-width="2"/>
                            <circle cx="100" cy="100" r="40" stroke="white" stroke-width="2"/>
                            <line x1="20" y1="100" x2="180" y2="100" stroke="white" stroke-width="2"/>
                            <line x1="100" y1="20" x2="100" y2="180" stroke="white" stroke-width="2"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Courses Section -->
    <section class="py-5">
        <div class="container">
            <h2 class="section-heading mb-4">Available Courses</h2>
            
            <div class="row">
                <?php 
                // Simpler approach with hardcoded field names
                if (isset($course_result) && mysqli_num_rows($course_result) > 0):
                    while($course = mysqli_fetch_assoc($course_result)): 
                ?>
                <div class="col-md-6 col-lg-4 mb-4 animate__animated animate__fadeIn">
                    <div class="card course-card h-100">
                        <div class="position-relative">
                            <?php 
                            // Use course thumbnail if available, otherwise use a default image
                            $defaultImage = "assets/images/course-default.jpg";
                            $imageSrc = $defaultImage;
                            
                            // Check for thumbnail field in database
                            if (isset($course['thumbnail']) && !empty($course['thumbnail'])) {
                                // Clean up path - handle relative paths that start with ../
                                $thumbnail = $course['thumbnail'];
                                
                                // Remove any leading ../ from the path
                                if (strpos($thumbnail, '../') === 0) {
                                    $thumbnail = substr($thumbnail, 3);
                                }
                                
                                // Check multiple potential locations
                                $potentialPaths = [
                                    $thumbnail, // As is
                                    'uploads/thumbnails/' . basename($thumbnail), // In thumbnails dir
                                    '/uploads/thumbnails/' . basename($thumbnail) // With leading slash
                                ];
                                
                                foreach ($potentialPaths as $path) {
                                    if (file_exists($path)) {
                                        $imageSrc = $path;
                                        break;
                                    }
                                }
                            } else {
                                // Try course_id based naming convention as fallback
                                $potentialPaths = [
                                    'uploads/thumbnails/course_' . $course['course_id'] . '.jpg',
                                    'uploads/thumbnails/course_' . $course['course_id'] . '.png'
                                ];
                                
                                foreach ($potentialPaths as $path) {
                                    if (file_exists($path)) {
                                        $imageSrc = $path;
                                        break;
                                    }
                                }
                            }
                            ?>
                            <img src="<?php echo htmlspecialchars($imageSrc); ?>" 
                                 alt="<?php echo isset($course['title']) ? htmlspecialchars($course['title']) : 'Course'; ?>" 
                                 class="card-img-top course-image">
                            <span class="badge course-badge" style="background-color: <?php echo $current_category['color']; ?>">
                                <i class="fas <?php echo $current_category['icon']; ?> me-1"></i> <?php echo $current_category['name']; ?>
                            </span>
                        </div>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title fw-bold"><?php echo isset($course['title']) ? htmlspecialchars($course['title']) : 'Untitled Course'; ?></h5>
                            
                            <?php if (isset($course['description'])): ?>
                            <p class="card-text text-muted"><?php echo htmlspecialchars($course['description']); ?></p>
                            <?php endif; ?>
                            
                            <div class="course-meta mt-auto">
                                <span><i class="fas fa-users"></i> <?php echo intval($course['student_count']); ?> students</span>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-top-0 text-center p-3">
                            <a href="course.php?id=<?php echo isset($course['course_id']) ? $course['course_id'] : 1; ?>" class="btn btn-primary w-100">View Course</a>
                        </div>
                    </div>
                </div>
                <?php 
                    endwhile; 
                else: 
                ?>
                <div class="col-12 text-center py-5">
                    <div class="py-5">
                        <i class="fas fa-book fa-3x text-muted mb-3"></i>
                        <h3>No courses found</h3>
                        <p class="text-muted">There are currently no courses available in this category.</p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="text-center mt-4">
                <a href="categories.php" class="btn btn-outline-primary">View All Categories</a>
            </div>
        </div>
    </section>
    
    <?php else: ?>
    <!-- All Categories Header -->
    <header class="category-header">
        <div class="container">
            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">All Categories</li>
                </ol>
            </nav>
            
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="category-icon">
                        <i class="fas fa-th-large"></i>
                    </div>
                    <h1 class="display-4 fw-bold mb-3">Course Categories</h1>
                    <p class="lead mb-0">Explore our comprehensive range of courses across different categories</p>
                </div>
            </div>
        </div>
    </header>
    
    <!-- All Categories Grid -->
    <section class="py-5">
        <div class="container">
            <div class="all-categories-grid">
                <?php foreach ($categories as $slug => $category): ?>
                <?php
                // Get course count for this category
                $cat_id = $category['id'];
                $count_query = "SELECT COUNT(*) as course_count FROM courses WHERE category_id = '$cat_id'";
                $count_result = mysqli_query($conn, $count_query);
                $course_count = 0;
                if ($count_result && $count_row = mysqli_fetch_assoc($count_result)) {
                    $course_count = $count_row['course_count'];
                }
                ?>
                <a href="categories.php?cat=<?php echo $slug; ?>" class="text-decoration-none">
                    <div class="category-card">
                        <div class="category-card-header" style="background-color: <?php echo $category['color']; ?>">
                            <div class="category-card-icon">
                                <i class="fas <?php echo $category['icon']; ?>"></i>
                            </div>
                            <h3 class="h4 fw-bold mb-0"><?php echo $category['name']; ?></h3>
                        </div>
                        <div class="category-card-body">
                            <p class="text-muted mb-3"><?php echo $category['description']; ?></p>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="badge rounded-pill bg-light text-dark"><?php echo $course_count; ?> courses</span>
                                <i class="fas fa-arrow-right text-primary"></i>
                            </div>
                        </div>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    
    <!-- Back to top button -->
    <a href="#" class="back-to-top" id="backToTop">
        <i class="fas fa-arrow-up"></i>
    </a>
    
    <!-- Footer (removed include) -->
    <footer class="bg-dark text-white py-4 mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5>Panadite Academy</h5>
                    <p>Empowering your future through education</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p>&copy; <?php echo date('Y'); ?> Panadite Academy. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript for animations and Back To Top button -->    
    <script>
        // Back to top functionality
        const backToTop = document.querySelector('.back-to-top');
        
        window.addEventListener('scroll', () => {
            if (window.pageYOffset > 300) {
                backToTop.classList.add('active');
            } else {
                backToTop.classList.remove('active');
            }
        });
        
        backToTop.addEventListener('click', (e) => {
            e.preventDefault();
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
        
        // Enhanced scroll reveal animations for course and category cards
        document.addEventListener('DOMContentLoaded', function() {
            const courseCards = document.querySelectorAll('.course-card');
            const categoryCards = document.querySelectorAll('.category-card');
            
            // Create intersection observer for cards
            const observer = new IntersectionObserver((entries) => {
                entries.forEach((entry) => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                        observer.unobserve(entry.target);
                    }
                });
            }, { threshold: 0.15, rootMargin: '0px 0px -50px 0px' });
            
            // Set initial styles and observe course cards
            courseCards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(30px)';
                card.style.transition = 'opacity 0.6s ease, transform 0.7s ease';
                card.style.transitionDelay = `${index * 0.1}s`;
                observer.observe(card);
            });
            
            // Set initial styles and observe category cards
            categoryCards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(30px)';
                card.style.transition = 'opacity 0.6s ease, transform 0.7s ease';
                card.style.transitionDelay = `${index * 0.1}s`;
                observer.observe(card);
            });
        });
    </script>
</body>
</html>
