<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="index.php">
            <i class="fas fa-graduation-cap me-2 text-warning"></i>
            <span class="fw-bold">Panadite Academy</span>
            <span class="badge bg-warning text-dark ms-2 fw-normal">CMS</span>
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'index.php' ? 'active' : ''; ?>" 
                       href="index.php">
                        <i class="fas fa-tachometer-alt me-1"></i>Dashboard
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo basename($_SERVER['PHP_SELF']) === 'content.php' ? 'active' : ''; ?>" 
                       href="#" id="contentDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-edit me-1"></i>Content
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="content.php?page=homepage">
                            <i class="fas fa-home me-2"></i>Homepage
                        </a></li>
                        <li><a class="dropdown-item" href="content.php?page=courses">
                            <i class="fas fa-graduation-cap me-2"></i>Courses Page
                        </a></li>
                        <li><a class="dropdown-item" href="content.php?page=about">
                            <i class="fas fa-users me-2"></i>About Page
                        </a></li>
                        <li><a class="dropdown-item" href="content.php?page=teaching-requirements">
                            <i class="fas fa-chalkboard-teacher me-2"></i>Teaching Requirements
                        </a></li>
                    </ul>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'images.php' ? 'active' : ''; ?>" 
                       href="images.php">
                        <i class="fas fa-images me-1"></i>Images
                    </a>
                </li>
            </ul>
            
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" href="../../index.php" target="_blank">
                        <i class="fas fa-external-link-alt me-1"></i>View Site
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle me-1"></i>
                        <?php echo htmlspecialchars($_SESSION['cms_admin_name'] ?? $_SESSION['cms_admin_username']); ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><h6 class="dropdown-header">
                            <i class="fas fa-user me-2"></i>
                            <?php echo htmlspecialchars($_SESSION['cms_admin_name'] ?? 'Admin User'); ?>
                        </h6></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="profile.php">
                            <i class="fas fa-cog me-2"></i>Settings
                        </a></li>
                        <li><a class="dropdown-item" href="activity.php">
                            <i class="fas fa-history me-2"></i>Activity Log
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-danger" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>

<style>
    .navbar-brand {
        font-size: 1.2rem;
    }
    
    .navbar-nav .nav-link {
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .navbar-nav .nav-link:hover {
        color: #f59e0b !important;
    }
    
    .navbar-nav .nav-link.active {
        color: #f59e0b !important;
        font-weight: 600;
    }
    
    .dropdown-menu {
        border-radius: 12px;
        border: none;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }
    
    .dropdown-item {
        padding: 0.5rem 1rem;
        transition: all 0.3s ease;
    }
    
    .dropdown-item:hover {
        background-color: rgba(245, 158, 11, 0.1);
        color: #f59e0b;
    }
</style>
