<?php
// Debug version of save content
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$response = [
    'success' => false,
    'message' => 'Debug mode',
    'debug' => [],
    'step' => 0
];

try {
    $response['step'] = 1;
    $response['debug'][] = 'Started debug script';

    // Force proper session configuration for production Linux server
    ini_set('session.save_handler', 'files');
    ini_set('session.save_path', '/tmp');
    ini_set('session.use_cookies', 1);
    ini_set('session.cookie_lifetime', 0);
    ini_set('session.cookie_path', '/');
    ini_set('session.cookie_domain', '');
    ini_set('session.cookie_secure', 0);
    ini_set('session.cookie_httponly', 1);
    
    $response['debug'][] = 'Session configuration forced for production server';

    // Test session
    session_start();
    $response['debug'][] = 'Session started successfully';
    $response['session_id'] = session_id();

    $response['step'] = 2;

    // Test file includes
    if (file_exists('../../includes/db.php')) {
        $response['debug'][] = 'Database file exists';
        try {
            require_once '../../includes/db.php';
            $response['debug'][] = 'Database file included successfully';
        } catch (Exception $e) {
            $response['debug'][] = 'Database include failed: ' . $e->getMessage();
        }
    } else {
        $response['debug'][] = 'Database file NOT found';
    }

    $response['step'] = 3;

    if (file_exists('cms_functions.php')) {
        $response['debug'][] = 'CMS functions file exists';
        try {
            require_once 'cms_functions.php';
            $response['debug'][] = 'CMS functions included successfully';
        } catch (Exception $e) {
            $response['debug'][] = 'CMS functions include failed: ' . $e->getMessage();
        }
    } else {
        $response['debug'][] = 'CMS functions file NOT found';
    }

    $response['step'] = 4;

    // Test admin session
    if (isset($_SESSION['cms_admin_id'])) {
        $response['debug'][] = 'Admin session found: ' . $_SESSION['cms_admin_id'];
        $response['admin_logged_in'] = true;
    } else {
        $response['debug'][] = 'Admin session NOT found';
        $response['admin_logged_in'] = false;
        $response['session_data'] = $_SESSION;
    }

    $response['step'] = 5;

    // Test POST data
    $response['post_data'] = $_POST;
    if (isset($_POST['page_name']) && isset($_POST['section_key']) && isset($_POST['content'])) {
        $response['debug'][] = 'All required POST data found';
    } else {
        $response['debug'][] = 'Missing POST data';
    }

    $response['step'] = 6;

    // Test database connection
    if (isset($conn)) {
        $response['debug'][] = 'Database connection variable exists';
        if ($conn) {
            $response['debug'][] = 'Database connection is active';
            $response['db_connected'] = true;
        } else {
            $response['debug'][] = 'Database connection is null';
            $response['db_connected'] = false;
        }
    } else {
        $response['debug'][] = 'Database connection variable not found';
        $response['db_connected'] = false;
    }

    $response['step'] = 7;

    // Test ensureCMSDatabase function
    if (function_exists('ensureCMSDatabase')) {
        $response['debug'][] = 'ensureCMSDatabase function exists';
        try {
            $db_result = ensureCMSDatabase();
            $response['debug'][] = 'ensureCMSDatabase result: ' . ($db_result ? 'true' : 'false');
        } catch (Exception $e) {
            $response['debug'][] = 'ensureCMSDatabase failed: ' . $e->getMessage();
        }
    } else {
        $response['debug'][] = 'ensureCMSDatabase function NOT found';
    }

    $response['step'] = 8;
    $response['success'] = true;
    $response['message'] = 'Debug completed successfully';

} catch (Exception $e) {
    $response['debug'][] = 'Exception at step ' . $response['step'] . ': ' . $e->getMessage();
    $response['error'] = $e->getMessage();
} catch (Error $e) {
    $response['debug'][] = 'Fatal error at step ' . $response['step'] . ': ' . $e->getMessage();
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
?>
