<?php
// Simple test save endpoint to identify the issue
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1); // Show errors for debugging

$response = [
    'success' => false,
    'message' => 'Test endpoint',
    'debug' => []
];

try {
    $response['debug'][] = 'Step 1: Started test endpoint';
    
    // Force session configuration
    ini_set('session.save_handler', 'files');
    ini_set('session.save_path', '/tmp');
    ini_set('session.use_cookies', 1);
    ini_set('session.cookie_lifetime', 0);
    ini_set('session.cookie_path', '/');
    ini_set('session.cookie_domain', '');
    ini_set('session.cookie_secure', 0);
    ini_set('session.cookie_httponly', 1);
    
    $response['debug'][] = 'Step 2: Session config set';
    
    // Start session
    session_start();
    $response['debug'][] = 'Step 3: Session started - ID: ' . session_id();
    
    // Check session data
    $response['session_data'] = $_SESSION;
    $response['debug'][] = 'Step 4: Session data retrieved';
    
    // Check POST data
    $response['post_data'] = $_POST;
    $response['debug'][] = 'Step 5: POST data retrieved';
    
    // Check admin status
    $response['admin_logged_in'] = isset($_SESSION['cms_admin_id']);
    $response['debug'][] = 'Step 6: Admin check completed';
    
    // Try to include database file
    if (file_exists('../../includes/db.php')) {
        require_once '../../includes/db.php';
        $response['debug'][] = 'Step 7: Database file included';
    } else {
        $response['debug'][] = 'Step 7: Database file NOT found';
    }
    
    // Try to include CMS functions
    if (file_exists('cms_functions.php')) {
        require_once 'cms_functions.php';
        $response['debug'][] = 'Step 8: CMS functions included';
    } else {
        $response['debug'][] = 'Step 8: CMS functions NOT found';
    }
    
    $response['success'] = true;
    $response['message'] = 'Test completed successfully';
    
} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = 'Error: ' . $e->getMessage();
    $response['debug'][] = 'Exception caught: ' . $e->getMessage();
} catch (Error $e) {
    $response['success'] = false;
    $response['message'] = 'Fatal Error: ' . $e->getMessage();
    $response['debug'][] = 'Fatal error caught: ' . $e->getMessage();
}

echo json_encode($response);
?>
