<?php
session_start();
require_once 'includes/db_connection.php';

// Include SEO headers with favicon for course guidelines page
$seo_title = 'Course Guidelines - Panadite Academy | Quality Standards & Requirements';
$seo_description = 'Learn about Panadite Academy\'s course quality guidelines and standards. Understand requirements for creating engaging, professional online courses.';
require_once __DIR__ . '/includes/seo_header.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Course Guidelines - Panadite Academy</title>
    <meta name="description" content="Learn how to create high-quality courses that engage students and meet Panadite Academy's standards.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #276BE4;
            --primary-amber: #FFA915;
            --dark-text: #2d3748;
            --light-text: #718096;
            --bg-light: #f8fafc;
            --border-color: #e2e8f0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-text);
            background-color: var(--bg-light);
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--dark-text);
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(255, 169, 21, 0.04) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(39, 107, 228, 0.04) 0%, transparent 50%);
            animation: backgroundPulse 8s ease-in-out infinite alternate;
        }
        
        @keyframes backgroundPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.8; }
        }
        
        .floating-element {
            position: absolute;
            pointer-events: none;
            opacity: 0.1;
        }
        
        .floating-element:nth-child(1) {
            top: 15%;
            left: 5%;
            animation: float1 7s ease-in-out infinite;
        }
        
        .floating-element:nth-child(2) {
            top: 60%;
            right: 10%;
            animation: float2 9s ease-in-out infinite reverse;
        }
        
        .floating-element:nth-child(3) {
            bottom: 25%;
            left: 75%;
            animation: float3 6s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(25px, -15px) rotate(180deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(-30px, -25px) rotate(-180deg); }
        }
        
        @keyframes float3 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(15px, 20px) rotate(360deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }
        
        .hero-content h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            line-height: 1.2;
            color: var(--dark-text);
            animation: fadeInUp 1s ease-out 0.2s both;
        }
        
        .hero-content p {
            font-size: 1.1rem;
            color: var(--light-text);
            margin-bottom: 2rem;
            max-width: 600px;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .content-section {
            background: white;
            border-radius: 16px;
            padding: 3rem;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
        }
        
        .section-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            background: linear-gradient(135deg, var(--primary-amber), #ff8f00);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            font-size: 1.25rem;
        }
        
        .guideline-card {
            background: var(--bg-light);
            border-radius: 12px;
            padding: 2rem;
            margin-bottom: 1.5rem;
            border-left: 4px solid var(--primary-amber);
            transition: all 0.3s ease;
        }
        
        .guideline-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(255, 169, 21, 0.15);
        }
        
        .guideline-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--dark-text);
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
        }
        
        .guideline-title i {
            color: var(--primary-amber);
            margin-right: 0.75rem;
            font-size: 1.1rem;
        }
        
        .guideline-description {
            color: var(--light-text);
            font-size: 1rem;
            line-height: 1.6;
            margin-bottom: 1rem;
        }
        
        .best-practices {
            list-style: none;
            padding: 0;
        }
        
        .best-practices li {
            padding: 0.5rem 0;
            display: flex;
            align-items: flex-start;
        }
        
        .best-practices li i {
            color: #10b981;
            margin-right: 0.75rem;
            margin-top: 0.25rem;
            font-size: 0.9rem;
        }
        
        .dos-donts {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
            margin-top: 2rem;
        }
        
        .dos, .donts {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            border: 1px solid var(--border-color);
        }
        
        .dos {
            border-left: 4px solid #10b981;
        }
        
        .donts {
            border-left: 4px solid #ef4444;
        }
        
        .dos h4 {
            color: #10b981;
            font-weight: 600;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
        }
        
        .donts h4 {
            color: #ef4444;
            font-weight: 600;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
        }
        
        .dos h4 i, .donts h4 i {
            margin-right: 0.5rem;
        }
        
        .checklist {
            list-style: none;
            padding: 0;
        }
        
        .checklist li {
            padding: 0.5rem 0;
            display: flex;
            align-items: flex-start;
            font-size: 0.95rem;
        }
        
        .checklist li i {
            margin-right: 0.75rem;
            margin-top: 0.25rem;
            font-size: 0.85rem;
        }
        
        .cta-section {
            background: linear-gradient(135deg, var(--primary-blue), #1e5bcc);
            color: white;
            border-radius: 16px;
            padding: 3rem;
            text-align: center;
            margin-top: 3rem;
        }
        
        .cta-section h2 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .cta-section p {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 2rem;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .btn-get-started {
            background: white;
            color: var(--primary-blue);
            padding: 1rem 2rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 1.1rem;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-get-started:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            color: var(--primary-blue);
        }
        
        .btn-get-started i {
            margin-left: 0.5rem;
        }
        
        .back-btn {
            background: white;
            color: var(--primary-blue);
            border: 1px solid var(--border-color);
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .back-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }
        
        .back-btn i {
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <section class="hero-section">
        <!-- Floating animated elements -->
        <div class="floating-element">
            <i class="fas fa-book-open" style="font-size: 55px; color: var(--primary-amber);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-lightbulb" style="font-size: 40px; color: var(--primary-blue);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-check-circle" style="font-size: 38px; color: #10b981;"></i>
        </div>
        
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1>Course Guidelines</h1>
                        <p>Learn how to create engaging, high-quality courses that provide real value to students and meet Panadite Academy's educational standards.</p>
                    </div>
                </div>
                <div class="col-lg-4 text-center">
                    <div style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border: 1px solid var(--border-color);">
                        <i class="fas fa-book-open" style="font-size: 3rem; margin-bottom: 1rem; color: var(--primary-amber);"></i>
                        <h4 style="margin: 0; font-weight: 700; color: var(--dark-text);">Create Quality</h4>
                        <p style="margin: 0.5rem 0 0; color: var(--light-text); font-size: 0.95rem;">Engage Students</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <div class="container">
        <a href="index.php" class="back-btn">
            <i class="fas fa-arrow-left"></i>
            Back to Home
        </a>
        
        <!-- Course Structure -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-sitemap"></i>
                Course Structure Guidelines
            </h2>
            <div class="row">
                <div class="col-md-6">
                    <div class="guideline-card">
                        <div class="guideline-title">
                            <i class="fas fa-list-ol"></i>
                            Course Organization
                        </div>
                        <div class="guideline-description">
                            Structure your course with clear sections and logical progression.
                        </div>
                        <ul class="best-practices">
                            <li><i class="fas fa-check"></i>Start with course overview and objectives</li>
                            <li><i class="fas fa-check"></i>Break content into digestible modules</li>
                            <li><i class="fas fa-check"></i>Include progress tracking elements</li>
                            <li><i class="fas fa-check"></i>End with summary and next steps</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="guideline-card">
                        <div class="guideline-title">
                            <i class="fas fa-clock"></i>
                            Lesson Length
                        </div>
                        <div class="guideline-description">
                            Keep lessons focused and appropriately timed for optimal engagement.
                        </div>
                        <ul class="best-practices">
                            <li><i class="fas fa-check"></i>5-15 minutes per video lesson</li>
                            <li><i class="fas fa-check"></i>Maximum 30 minutes for complex topics</li>
                            <li><i class="fas fa-check"></i>Include breaks in longer sessions</li>
                            <li><i class="fas fa-check"></i>Provide chapter markers for navigation</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Content Quality -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-star"></i>
                Content Quality Standards
            </h2>
            <div class="row">
                <div class="col-md-4">
                    <div class="guideline-card">
                        <div class="guideline-title">
                            <i class="fas fa-video"></i>
                            Video Quality
                        </div>
                        <div class="guideline-description">
                            Ensure professional video and audio quality.
                        </div>
                        <ul class="best-practices">
                            <li><i class="fas fa-check"></i>Minimum 720p HD resolution</li>
                            <li><i class="fas fa-check"></i>Clear, crisp audio without background noise</li>
                            <li><i class="fas fa-check"></i>Good lighting and framing</li>
                            <li><i class="fas fa-check"></i>Consistent audio levels throughout</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="guideline-card">
                        <div class="guideline-title">
                            <i class="fas fa-presentation"></i>
                            Visual Design
                        </div>
                        <div class="guideline-description">
                            Create visually appealing and educational content.
                        </div>
                        <ul class="best-practices">
                            <li><i class="fas fa-check"></i>Clean, readable slide designs</li>
                            <li><i class="fas fa-check"></i>Consistent fonts and colors</li>
                            <li><i class="fas fa-check"></i>High-quality images and graphics</li>
                            <li><i class="fas fa-check"></i>Avoid cluttered layouts</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="guideline-card">
                        <div class="guideline-title">
                            <i class="fas fa-file-alt"></i>
                            Course Materials
                        </div>
                        <div class="guideline-description">
                            Provide comprehensive learning resources.
                        </div>
                        <ul class="best-practices">
                            <li><i class="fas fa-check"></i>Downloadable PDFs and worksheets</li>
                            <li><i class="fas fa-check"></i>Code files and project resources</li>
                            <li><i class="fas fa-check"></i>Additional reading materials</li>
                            <li><i class="fas fa-check"></i>Practice exercises and quizzes</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Best Practices -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-lightbulb"></i>
                Teaching Best Practices
            </h2>
            <div class="dos-donts">
                <div class="dos">
                    <h4><i class="fas fa-thumbs-up"></i>DO's</h4>
                    <ul class="checklist">
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Start each lesson with clear objectives</li>
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Use real-world examples and case studies</li>
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Encourage student interaction and questions</li>
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Provide step-by-step instructions</li>
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Include hands-on projects and exercises</li>
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Offer multiple learning formats</li>
                        <li><i class="fas fa-check" style="color: #10b981;"></i>Regular course updates and improvements</li>
                    </ul>
                </div>
                <div class="donts">
                    <h4><i class="fas fa-thumbs-down"></i>DON'Ts</h4>
                    <ul class="checklist">
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Read directly from slides or scripts</li>
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Use poor quality audio or video</li>
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Make lessons too long or complex</li>
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Ignore student questions and feedback</li>
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Use inappropriate or offensive content</li>
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Copy content from other sources</li>
                        <li><i class="fas fa-times" style="color: #ef4444;"></i>Promise unrealistic outcomes</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Course Approval -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-clipboard-check"></i>
                Course Review Process
            </h2>
            <div class="guideline-card">
                <div class="guideline-title">
                    <i class="fas fa-search"></i>
                    Quality Review
                </div>
                <div class="guideline-description">
                    All courses undergo a thorough review process before publication to ensure they meet our quality standards.
                </div>
                <ul class="best-practices">
                    <li><i class="fas fa-check"></i><strong>Content Review:</strong> Educational value and accuracy assessment</li>
                    <li><i class="fas fa-check"></i><strong>Technical Review:</strong> Audio, video, and material quality check</li>
                    <li><i class="fas fa-check"></i><strong>Policy Compliance:</strong> Adherence to community guidelines</li>
                    <li><i class="fas fa-check"></i><strong>Student Experience:</strong> Overall learning experience evaluation</li>
                    <li><i class="fas fa-check"></i><strong>Feedback Integration:</strong> Incorporation of suggested improvements</li>
                </ul>
            </div>
        </div>
        
        <!-- Call to Action -->
        <div class="cta-section">
            <h2>Ready to Create Your Course?</h2>
            <p>Follow these guidelines to create engaging, high-quality courses that students love and learn from effectively.</p>
            <a href="auth/register.php" class="btn-get-started">
                Start Creating Your Course
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
