<?php
require_once '../config/db_connect.php';

echo "<h2>🔧 Adding Bio Column to Users Table</h2>";

// Check if bio column already exists
$result = $conn->query("SHOW COLUMNS FROM users LIKE 'bio'");
if ($result && $result->num_rows > 0) {
    echo "<div style='color: green; padding: 10px; border: 1px solid green; margin: 10px 0;'>";
    echo "✅ Bio column already exists in users table!";
    echo "</div>";
} else {
    echo "<div style='color: orange; padding: 10px; border: 1px solid orange; margin: 10px 0;'>";
    echo "⚠️ Bio column missing from users table. Adding now...";
    echo "</div>";
    
    // Add bio column
    $sql = "ALTER TABLE users ADD COLUMN bio TEXT NULL COMMENT 'User biography/description'";
    
    if ($conn->query($sql)) {
        echo "<div style='color: green; padding: 10px; border: 1px solid green; margin: 10px 0;'>";
        echo "✅ <strong>SUCCESS!</strong> Bio column added successfully to users table.";
        echo "</div>";
        
        // Verify the column was added
        $verify = $conn->query("SHOW COLUMNS FROM users LIKE 'bio'");
        if ($verify && $verify->num_rows > 0) {
            $column_info = $verify->fetch_assoc();
            echo "<div style='padding: 10px; background: #f0f8ff; border: 1px solid #ccc; margin: 10px 0;'>";
            echo "<strong>Column Details:</strong><br>";
            echo "Field: " . $column_info['Field'] . "<br>";
            echo "Type: " . $column_info['Type'] . "<br>";
            echo "Null: " . $column_info['Null'] . "<br>";
            echo "</div>";
        }
    } else {
        echo "<div style='color: red; padding: 10px; border: 1px solid red; margin: 10px 0;'>";
        echo "❌ <strong>ERROR!</strong> Failed to add bio column: " . $conn->error;
        echo "</div>";
    }
}

echo "<hr>";
echo "<h3>📋 Current Users Table Structure:</h3>";

// Show current table structure
$result = $conn->query("SHOW COLUMNS FROM users");
if ($result) {
    echo "<table border='1' cellpadding='8' cellspacing='0' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #f5f5f5;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        $highlight = ($row['Field'] === 'bio') ? "style='background: #e8f5e8;'" : "";
        echo "<tr $highlight>";
        echo "<td><strong>" . $row['Field'] . "</strong></td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . ($row['Default'] ?: 'NULL') . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<div style='margin-top: 20px; padding: 15px; background: #f0f8ff; border: 1px solid #2563eb;'>";
echo "<h4>🎯 Next Steps:</h4>";
echo "1. The bio column has been added to the users table<br>";
echo "2. You can now return to your profile page<br>";
echo "3. Try updating your profile again - it should work now!<br>";
echo "4. The bio field will allow users to add personal descriptions<br>";
echo "</div>";

$conn->close();
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
table { width: 100%; }
th { text-align: left; }
td, th { padding: 8px; }
</style>
