<?php
// Debug authentication and session issues
require_once '../auth/functions.php';

echo "<h2>Authentication Debug Information</h2>";

echo "<h3>Session Data:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h3>Authentication Checks:</h3>";
echo "<p><strong>isLoggedIn():</strong> " . (isLoggedIn() ? 'TRUE' : 'FALSE') . "</p>";

if (isset($_SESSION['role'])) {
    echo "<p><strong>Session Role:</strong> " . $_SESSION['role'] . "</p>";
    echo "<p><strong>hasPermission('student'):</strong> " . (hasPermission('student') ? 'TRUE' : 'FALSE') . "</p>";
    echo "<p><strong>hasPermission('teacher'):</strong> " . (hasPermission('teacher') ? 'TRUE' : 'FALSE') . "</p>";
    echo "<p><strong>hasPermission('admin'):</strong> " . (hasPermission('admin') ? 'TRUE' : 'FALSE') . "</p>";
} else {
    echo "<p><strong>Session Role:</strong> NOT SET</p>";
}

echo "<h3>Manual Role Check:</h3>";
if (isLoggedIn()) {
    if (!hasPermission('student')) {
        echo "<p style='color: red;'><strong>ISSUE FOUND:</strong> User is logged in but doesn't have student permission</p>";
        
        // Check what's in the session role
        if (isset($_SESSION['role'])) {
            echo "<p>Session role is: '" . $_SESSION['role'] . "'</p>";
            if ($_SESSION['role'] !== 'student') {
                echo "<p style='color: orange;'>Role mismatch - session role is not 'student'</p>";
            }
        } else {
            echo "<p style='color: red;'>No role set in session</p>";
        }
    } else {
        echo "<p style='color: green;'><strong>SUCCESS:</strong> User has student permission</p>";
    }
} else {
    echo "<p style='color: red;'><strong>ISSUE:</strong> User is not logged in</p>";
}

echo "<h3>Function Tests:</h3>";

// Test the individual functions
echo "<p><strong>Direct Session Checks:</strong></p>";
echo "<ul>";
echo "<li>_SESSION['logged_in']: " . (isset($_SESSION['logged_in']) ? ($_SESSION['logged_in'] ? 'true' : 'false') : 'not set') . "</li>";
echo "<li>_SESSION['is_logged_in']: " . (isset($_SESSION['is_logged_in']) ? ($_SESSION['is_logged_in'] ? 'true' : 'false') : 'not set') . "</li>";
echo "<li>_SESSION['user_id']: " . (isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 'not set') . "</li>";
echo "<li>_SESSION['role']: " . (isset($_SESSION['role']) ? $_SESSION['role'] : 'not set') . "</li>";
echo "<li>_SESSION['user_role']: " . (isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'not set') . "</li>";
echo "</ul>";

echo "<h3>Test Access to Messages:</h3>";
try {
    // Simulate the requireRole check
    if (!isLoggedIn()) {
        echo "<p style='color: red;'>FAIL: Not logged in - would redirect to login</p>";
    } elseif (!hasPermission('student')) {
        echo "<p style='color: red;'>FAIL: No student permission - would redirect to unauthorized</p>";
    } else {
        echo "<p style='color: green;'>PASS: Should be able to access messages page</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>ERROR: " . $e->getMessage() . "</p>";
}

echo "<p><a href='../student/dashboard.php'>Back to Dashboard</a></p>";
echo "<p><a href='../student/messages.php'>Try Messages Page</a></p>";
?>
