<?php
// Start session with same settings
session_start();

echo "<h1>Session Check Tool</h1>";
echo "<h2>Current Session Information</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h2>Session Settings</h2>";
echo "Session ID: " . session_id() . "<br>";
echo "Session Name: " . session_name() . "<br>";
echo "Session Cookie Path: " . ini_get('session.cookie_path') . "<br>";
echo "Session Cookie Domain: " . ini_get('session.cookie_domain') . "<br>";
echo "Session Cookie Lifetime: " . ini_get('session.cookie_lifetime') . "<br>";

echo "<h2>Cookie Information</h2>";
echo "<pre>";
print_r($_COOKIE);
echo "</pre>";

// Create a simple test form to test setting session variables
echo "<h2>Set Test Session Variable</h2>";
if (isset($_POST['set_session'])) {
    $_SESSION['test_var'] = $_POST['test_value'];
    echo "<p style='color:green'>Set test_var to: " . $_SESSION['test_var'] . "</p>";
}

echo "<form method='post'>";
echo "<input type='text' name='test_value' value='test_session_value'>";
echo "<button type='submit' name='set_session'>Set Session Var</button>";
echo "</form>";

echo "<h2>Links</h2>";
echo "<ul>";
echo "<li><a href='../student/messages.php'>Go to Messages</a></li>";
echo "<li><a href='test_api.php'>Test API Call</a></li>";
echo "</ul>";
?>
