<?php
// Debug script to test API message sending
session_start();

echo "<h1>API Message Sending Debug</h1>";

echo "<h2>Current Session</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

// Create a test form to send a message through the API
echo "<h2>Test Message Form</h2>";
?>

<form id="debugMessageForm">
  <div style="margin-bottom: 10px;">
    <label for="recipient_id">Recipient ID:</label>
    <input type="number" id="recipient_id" name="recipient_id" value="2" required>
  </div>
  
  <div style="margin-bottom: 10px;">
    <label for="message">Message:</label>
    <textarea id="message" name="message" required>Test message from debug script</textarea>
  </div>
  
  <div style="margin-bottom: 10px;">
    <label for="course_id">Course ID (optional):</label>
    <input type="number" id="course_id" name="course_id" value="">
  </div>
  
  <button type="button" id="sendButton">Send Test Message</button>
</form>

<div id="result" style="margin-top: 20px; padding: 10px; border: 1px solid #ccc;"></div>

<script>
document.getElementById('sendButton').addEventListener('click', function() {
  const formData = new FormData();
  formData.append('recipient_id', document.getElementById('recipient_id').value);
  formData.append('message', document.getElementById('message').value);
  
  const courseId = document.getElementById('course_id').value;
  if (courseId) {
    formData.append('course_id', courseId);
  }
  
  // Show loading
  document.getElementById('result').innerHTML = 'Sending...';
  
  fetch('../student/api/send_message.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    document.getElementById('result').innerHTML = '<pre>' + JSON.stringify(data, null, 2) + '</pre>';
  })
  .catch(error => {
    document.getElementById('result').innerHTML = 'Error: ' + error;
  });
});
</script>

<p><a href="../student/messages.php">Return to messages</a></p>
