<?php
/**
 * Quick Fix for payment_status Column
 * Fixes the SQL syntax error in the ENUM default value
 */

require_once '../config/db_connect.php';

echo "<!DOCTYPE html><html><head><title>Fix Payment Status Column</title>";
echo "<style>body{font-family:Arial,sans-serif;max-width:800px;margin:20px auto;padding:20px;} .success{color:#28a745;background:#d4edda;padding:10px;border-radius:5px;margin:10px 0;} .error{color:#dc3545;background:#f8d7da;padding:10px;border-radius:5px;margin:10px 0;}</style></head><body>";

echo "<h1>🔧 Payment Status Column Fix</h1>";

// Check if payment_status column exists
$checkColumn = $conn->query("SHOW COLUMNS FROM accreditation_requests LIKE 'payment_status'");
if ($checkColumn && $checkColumn->num_rows > 0) {
    echo "<div class='error'>⚠️ Column 'payment_status' already exists - no action needed</div>";
} else {
    echo "<p>Adding missing payment_status column with correct syntax...</p>";
    
    // Fix the SQL syntax issue - properly quote the default value
    $sql = "ALTER TABLE accreditation_requests ADD COLUMN payment_status ENUM('pending', 'completed', 'failed', 'refunded') NOT NULL DEFAULT 'pending'";
    
    if ($conn->query($sql) === TRUE) {
        echo "<div class='success'>✅ Successfully added payment_status column!</div>";
    } else {
        echo "<div class='error'>❌ Error: " . $conn->error . "</div>";
    }
}

// Verify the column now exists
echo "<h3>Verification:</h3>";
$result = $conn->query("SHOW COLUMNS FROM accreditation_requests LIKE 'payment_status'");
if ($result && $result->num_rows > 0) {
    $column = $result->fetch_assoc();
    echo "<div class='success'>✅ payment_status column verified:</div>";
    echo "<ul>";
    echo "<li><strong>Type:</strong> " . $column['Type'] . "</li>";
    echo "<li><strong>Null:</strong> " . $column['Null'] . "</li>";
    echo "<li><strong>Default:</strong> " . $column['Default'] . "</li>";
    echo "</ul>";
} else {
    echo "<div class='error'>❌ payment_status column still missing</div>";
}

echo "</body></html>";
?>
