<?php
/**
 * 🚀 Quick Cancel - One-Click Accreditation Request Cancellation
 */

require_once '../config/db_connect.php';

// Simple HTML for quick action
echo "<!DOCTYPE html><html><head><title>Quick Cancel</title>";
echo "<style>body{font-family:Arial;max-width:800px;margin:50px auto;padding:20px;text-align:center;background:#f8f9fa;} .container{background:white;padding:40px;border-radius:10px;box-shadow:0 4px 20px rgba(0,0,0,0.1);} .success{color:#28a745;background:#d4edda;padding:20px;border-radius:5px;margin:20px 0;} .error{color:#dc3545;background:#f8d7da;padding:20px;border-radius:5px;margin:20px 0;} .btn{display:inline-block;padding:15px 30px;margin:10px;background:#dc3545;color:white;text-decoration:none;border-radius:5px;font-weight:bold;} .btn:hover{background:#c82333;} h1{color:#343a40;margin-bottom:30px;}</style>";
echo "</head><body><div class='container'>";
echo "<h1>🗑️ Quick Cancel Accreditation Request</h1>";

if (isset($_GET['confirm']) && $_GET['confirm'] === 'yes') {
    // Find and cancel ALL pending accreditation requests
    $result = $conn->query("
        UPDATE accreditation_requests 
        SET status = 'cancelled', updated_at = NOW() 
        WHERE status IN ('pending_payment', 'under_review', 'approved') 
        AND payment_status != 'completed'
    ");
    
    $cancelled_count = $conn->affected_rows;
    
    if ($cancelled_count > 0) {
        echo "<div class='success'>";
        echo "<h2>✅ Success!</h2>";
        echo "<p><strong>Cancelled {$cancelled_count} accreditation request(s)</strong></p>";
        echo "<p>🎉 You can now test the new payment-first workflow!</p>";
        echo "<p><strong>Next Steps:</strong></p>";
        echo "<ol style='text-align:left; max-width:400px; margin:20px auto;'>";
        echo "<li>Go back to your course certificate tab</li>";
        echo "<li>You should see the new green 'Pay R500 & Request Certificate' button</li>";
        echo "<li>Click it to test the PayFast integration</li>";
        echo "</ol>";
        echo "</div>";
        
        echo "<a href='../course-detail.php' style='background:#28a745;' class='btn'>🎯 Go Test Payment Button</a>";
    } else {
        echo "<div class='error'>";
        echo "<h2>ℹ️ No Active Requests Found</h2>";
        echo "<p>There are no pending accreditation requests to cancel.</p>";
        echo "<p>The payment interface should already be available!</p>";
        echo "</div>";
        
        echo "<a href='../course-detail.php' style='background:#28a745;' class='btn'>🎯 Check Course Page</a>";
    }
    
} else {
    // Show current requests and confirmation
    $requests = $conn->query("
        SELECT ar.request_id, ar.status, ar.payment_status, ar.created_at,
               u.first_name, u.last_name, c.title as course_title
        FROM accreditation_requests ar
        JOIN users u ON ar.student_id = u.user_id  
        JOIN courses c ON ar.course_id = c.course_id
        WHERE ar.status NOT IN ('rejected', 'certificate_issued', 'cancelled')
        ORDER BY ar.created_at DESC
    ");
    
    if ($requests && $requests->num_rows > 0) {
        echo "<p>Found <strong>" . $requests->num_rows . "</strong> active accreditation request(s):</p>";
        echo "<div style='text-align:left; margin:20px 0; background:#f8f9fa; padding:15px; border-radius:5px;'>";
        
        while ($req = $requests->fetch_assoc()) {
            echo "<div style='background:white; padding:10px; margin:10px 0; border-left:3px solid #007bff;'>";
            echo "🎓 <strong>#{$req['request_id']}</strong> - {$req['first_name']} {$req['last_name']}<br>";
            echo "📚 {$req['course_title']}<br>";
            echo "📊 Status: " . ucwords(str_replace('_', ' ', $req['status'])) . "<br>";
            echo "💳 Payment: " . ucwords($req['payment_status']) . "<br>";
            echo "📅 " . date('M j, Y g:i A', strtotime($req['created_at']));
            echo "</div>";
        }
        echo "</div>";
        
        echo "<p style='color:#856404; background:#fff3cd; padding:15px; border-radius:5px;'>";
        echo "⚠️ <strong>This will cancel all active requests</strong><br>";
        echo "This allows you to test the new payment-first workflow from a clean state.";
        echo "</p>";
        
        echo "<a href='?confirm=yes' class='btn'>🗑️ Cancel All & Enable Testing</a>";
        
    } else {
        echo "<div style='color:#28a745; background:#d4edda; padding:20px; border-radius:5px;'>";
        echo "<h2>✅ No Active Requests!</h2>";
        echo "<p>The payment interface should already be available.</p>";
        echo "</div>";
        
        echo "<a href='../course-detail.php' style='background:#28a745;' class='btn'>🎯 Check Course Page</a>";
    }
}

echo "</div></body></html>";
?>
