<?php
/**
 * PANADITE ACADEMY - DYNAMIC SITEMAP GENERATOR
 * Automatically generates comprehensive sitemaps for maximum SEO discoverability
 * Updates in real-time with courses, categories, and content
 */

header('Content-Type: application/xml; charset=utf-8');

// Include database connection
require_once __DIR__ . '/includes/db_connection.php';

// Get current domain
$domain = 'https://panaditeacademy.com';
if (isset($_SERVER['HTTP_HOST'])) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $domain = $protocol . '://' . $_SERVER['HTTP_HOST'];
}

// Start XML
echo '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
        xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">

  <!-- Homepage - Highest Priority -->
  <url>
    <loc><?php echo $domain; ?>/</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>daily</changefreq>
    <priority>1.0</priority>
    <image:image>
      <image:loc><?php echo $domain; ?>/logo.jpeg</image:loc>
      <image:title>Panadite Academy - Professional Online Learning Platform</image:title>
      <image:caption>Transform your career with expert-led online courses and industry certifications</image:caption>
    </image:image>
  </url>

  <!-- Static Important Pages -->
  <url>
    <loc><?php echo $domain; ?>/courses.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>daily</changefreq>
    <priority>0.9</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/about.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>weekly</changefreq>
    <priority>0.8</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/contact.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/search.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>daily</changefreq>
    <priority>0.8</priority>
  </url>

  <!-- Authentication Pages -->
  <url>
    <loc><?php echo $domain; ?>/auth/login.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.6</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/auth/register.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.6</priority>
  </url>

<?php
// Dynamic Categories from Database
if ($conn && !$conn->connect_error) {
    $category_query = "SELECT category_id, category_name, created_at FROM categories ORDER BY category_name ASC";
    $category_result = $conn->query($category_query);
    
    if ($category_result && $category_result->num_rows > 0) {
        while ($category = $category_result->fetch_assoc()) {
            $category_url = $domain . '/category.php?id=' . urlencode($category['category_id']);
            $category_slug_url = $domain . '/category/' . urlencode(strtolower(str_replace(' ', '-', $category['category_name'])));
            $lastmod = isset($category['created_at']) ? date('c', strtotime($category['created_at'])) : date('c');
            
            echo "  <url>\n";
            echo "    <loc>" . htmlspecialchars($category_url) . "</loc>\n";
            echo "    <lastmod>" . $lastmod . "</lastmod>\n";
            echo "    <changefreq>weekly</changefreq>\n";
            echo "    <priority>0.8</priority>\n";
            echo "  </url>\n\n";
            
            // Also include SEO-friendly slug URL
            echo "  <url>\n";
            echo "    <loc>" . htmlspecialchars($category_slug_url) . "</loc>\n";
            echo "    <lastmod>" . $lastmod . "</lastmod>\n";
            echo "    <changefreq>weekly</changefreq>\n";
            echo "    <priority>0.8</priority>\n";
            echo "  </url>\n\n";
        }
    }
}
?>

<?php
// Dynamic Courses from Database
if ($conn && !$conn->connect_error) {
    $course_query = "SELECT course_id, title, description, thumbnail, created_at, updated_at 
                     FROM courses 
                     WHERE is_published = 1 
                     ORDER BY created_at DESC";
    $course_result = $conn->query($course_query);
    
    if ($course_result && $course_result->num_rows > 0) {
        while ($course = $course_result->fetch_assoc()) {
            $course_url = $domain . '/course-detail.php?id=' . urlencode($course['course_id']);
            $course_slug_url = $domain . '/course/' . urlencode(strtolower(str_replace(' ', '-', $course['title'])));
            $lastmod = isset($course['updated_at']) ? date('c', strtotime($course['updated_at'])) : 
                      (isset($course['created_at']) ? date('c', strtotime($course['created_at'])) : date('c'));
            
            echo "  <url>\n";
            echo "    <loc>" . htmlspecialchars($course_url) . "</loc>\n";
            echo "    <lastmod>" . $lastmod . "</lastmod>\n";
            echo "    <changefreq>weekly</changefreq>\n";
            echo "    <priority>0.8</priority>\n";
            
            // Add course thumbnail as image
            if (!empty($course['thumbnail'])) {
                $image_url = $domain . '/' . ltrim($course['thumbnail'], '/');
                echo "    <image:image>\n";
                echo "      <image:loc>" . htmlspecialchars($image_url) . "</image:loc>\n";
                echo "      <image:title>" . htmlspecialchars($course['title']) . "</image:title>\n";
                if (!empty($course['description'])) {
                    echo "      <image:caption>" . htmlspecialchars(substr($course['description'], 0, 200)) . "</image:caption>\n";
                }
                echo "    </image:image>\n";
            }
            
            echo "  </url>\n\n";
            
            // Also include SEO-friendly slug URL
            echo "  <url>\n";
            echo "    <loc>" . htmlspecialchars($course_slug_url) . "</loc>\n";
            echo "    <lastmod>" . $lastmod . "</lastmod>\n";
            echo "    <changefreq>weekly</changefreq>\n";
            echo "    <priority>0.8</priority>\n";
            echo "  </url>\n\n";
        }
    }
}
?>

  <!-- Teacher Application Pages -->
  <url>
    <loc><?php echo $domain; ?>/teacher/apply.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>weekly</changefreq>
    <priority>0.7</priority>
  </url>

  <!-- Additional Important Pages -->
  <url>
    <loc><?php echo $domain; ?>/privacy-policy.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.5</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/terms-of-service.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.5</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/help.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.6</priority>
  </url>

  <url>
    <loc><?php echo $domain; ?>/faq.php</loc>
    <lastmod><?php echo date('c'); ?></lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.6</priority>
  </url>

</urlset>
