<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once 'includes/db.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Panadite Academy</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #4e73df;
            --secondary-color: #224abe;
            --light-color: #f8f9fc;
            --border-radius: 12px;
        }
        /* Modern styling matching course page */
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: #f8f9fc;
        }
        
        /* Hero section */
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="rgba(255,255,255,0.1)"/><circle cx="80" cy="40" r="1" fill="rgba(255,255,255,0.15)"/><circle cx="40" cy="80" r="1.5" fill="rgba(255,255,255,0.1)"/></svg>');
            animation: float 20s ease-in-out infinite;
        }
        
        /* Animations */
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(180deg); }
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        /* Animation classes */
        .animate-fade-in {
            animation: fadeIn 1s ease-out forwards;
        }
        
        .animate-slide-left {
            animation: slideInLeft 1s ease-out forwards;
        }
        
        .animate-slide-right {
            animation: slideInRight 1s ease-out forwards;
        }
        
        .animate-delay-1 { animation-delay: 0.3s; }
        .animate-delay-2 { animation-delay: 0.6s; }
        .animate-delay-3 { animation-delay: 0.9s; }
        
        /* Card styling */
        .modern-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border: none;
            transition: all 0.3s ease;
            overflow: hidden;
        }
        
        .modern-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        /* Stats cards */
        .stat-card {
            text-align: center;
            padding: 2rem;
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary-color);
            display: block;
        }
        
        /* Team card */
        .team-card {
            text-align: center;
            padding: 2rem;
        }
        
        .team-avatar {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            margin: 0 auto 1rem;
            background: linear-gradient(45deg, #667eea, #764ba2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
        }
        
        /* Section styling */
        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }
        
        .section-title h2 {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 1rem;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: #718096;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Feature list */
        .feature-list {
            list-style: none;
            padding: 0;
        }
        
        .feature-list li {
            padding: 0.75rem 0;
            display: flex;
            align-items: center;
        }
        
        .feature-list li i {
            color: var(--primary-color);
            margin-right: 1rem;
            width: 20px;
        }
        
        /* Button styling */
        .btn-primary {
            background: var(--primary-color);
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(78, 115, 223, 0.3);
        }
            position: absolute;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 16px;
            opacity: 0.3;
            z-index: 1;
        }
        
        .floating-shape-1 {
            width: 60px;
            height: 60px;
            background-color: #276BE4;
            top: 30%;
            left: 10%;
            transform: rotate(15deg);
            animation: float-pulse 8s ease-in-out infinite alternate;
        }
        
        .floating-shape-2 {
            width: 50px;
            height: 50px;
            background-color: #FFA915;
            bottom: 20%;
            right: 5%;
            transform: rotate(-15deg);
            animation: float-scale 10s ease-in-out infinite alternate;
        }
        
        @keyframes float-up-down {
            0% { transform: translateY(0); }
            100% { transform: translateY(30px); }
        }
        
        @keyframes float-left-right {
            0% { transform: translateX(0); }
            100% { transform: translateX(40px); }
        }
        
        @keyframes float-rotate {
            0% { transform: rotate(0); }
            100% { transform: rotate(360deg); }
        }
        
        @keyframes float-pulse {
            0% { transform: scale(1) rotate(15deg); }
            50% { transform: scale(1.1) rotate(10deg); }
            100% { transform: scale(1) rotate(15deg); }
        }
        
        @keyframes float-scale {
            0% { transform: scale(1) rotate(-15deg); }
            50% { transform: scale(1.15) rotate(-10deg); }
            100% { transform: scale(1) rotate(-15deg); }
        }
        
        /* About Page Specific Styles */
        .team-member-card {
            border-radius: 16px;
            overflow: hidden;
            border: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .team-member-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        
        .team-member-image {
            height: 280px;
            background-position: center;
            background-size: cover;
        }
        
        .social-links {
            display: flex;
            gap: 10px;
        }
        
        .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background-color: rgba(39,107,228,0.1);
            color: #276BE4;
            transition: all 0.3s ease;
        }
        
        .social-link:hover {
            background-color: #276BE4;
            color: white;
        }
        
        .value-card {
            border-radius: 16px;
            border: none;
            padding: 25px;
            background-color: white;
            height: 100%;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s ease;
        }
        
        .value-card:hover {
            transform: translateY(-5px);
        }
        
        .value-icon {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 12px;
            font-size: 24px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <!-- Include the modern navbar -->    
    <?php include 'includes/navbar.php'; ?>

    <!-- Enhanced Page Header with Modern Design and Floating Animations -->
    <header class="py-5 banner-section position-relative overflow-hidden">
        <!-- Floating Animation Elements -->
        <div class="floating-elements">
            <div class="floating-circle floating-circle-1"></div>
            <div class="floating-circle floating-circle-2"></div>
            <div class="floating-circle floating-circle-3"></div>
            <div class="floating-shape floating-shape-1">
                <i class="fas fa-building text-white"></i>
            </div>
            <div class="floating-shape floating-shape-2">
                <i class="fas fa-users text-white"></i>
            </div>
        </div>

        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-8 animate__animated animate__fadeIn">
                    <div class="banner-content">
                        <h1 class="fw-bold display-4 mb-3">About <span class="text-primary text-gradient">Panadite Academy</span></h1>
                        <div class="accent-bar mb-4" style="width: 80px; height: 4px; background: linear-gradient(90deg, #276BE4, #FFA915); border-radius: 2px;"></div>
                        <p class="lead mb-4">We are passionate about transforming education through innovative learning solutions</p>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <section class="py-5">
        <div class="container">
            <div class="row align-items-center mb-5">
                <div class="col-lg-6 mb-4 mb-lg-0 animate__animated animate__fadeInLeft">
                   
                <h2 class="fw-bold mb-4">Our Vision</h2>
                    <div class="accent-bar mb-4" style="width: 60px; height: 3px; background: linear-gradient(90deg, #276BE4, #FFA915); border-radius: 2px;"></div>
                    <p class="mb-4">To empower individuals and companies with future-ready skills, enabling them to succeed in the rapidly evolving landscape of technology.</p>
                    
                
                <h2 class="fw-bold mb-4">Our Mission</h2>
                    <div class="accent-bar mb-4" style="width: 60px; height: 3px; background: linear-gradient(90deg, #276BE4, #FFA915); border-radius: 2px;"></div>
                    <p class="mb-4">Deliver education and cutting-edge technological skills that align with emerging industry demands, empowering individuals and the workforce.    </p>
                    <p>We deliver education that meets emerging industry demands while equipping individuals and organizations with the future-ready skills needed to adapt, innovate, and excel. Panadite Academy's offerings span essential fields such as end-user computing, data analysis, 16 data science, Python programming, artificial intelligence, cybersecurity, cloud administration, web development, and more. For businesses, we provide customized corporate training solutions, enabling them to upskill their workforce and maintain a competitive edge</p>

                   
                </div>
                <br>
                
                <div class="col-lg-6 animate__animated animate__fadeInRight">
                    <div class="rounded-4 overflow-hidden shadow-sm">
                        <div style="background: linear-gradient(45deg, rgba(39, 107, 228, 0.8), rgba(66, 133, 244, 0.8)), url('https://images.unsplash.com/photo-1522202176988-66273c2fd55f?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=1171&q=80'); height: 350px; background-size: cover; background-position: center;" class="d-flex align-items-center justify-content-center">
                            <div class="text-center text-white p-4">
                                <i class="fas fa-graduation-cap fa-3x mb-3"></i>
                                <h3 class="fw-bold">Transforming Education</h3>
                                <p class="mb-0">Through innovation and accessibility</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Our Values Section -->
            <div class="mt-5 pt-3">
                <div class="text-center mb-5">
                    <h2 class="fw-bold">Our Core Values</h2>
                    <div class="accent-bar mx-auto mb-4" style="width: 60px; height: 3px; background: linear-gradient(90deg, #276BE4, #FFA915); border-radius: 2px;"></div>
                    <p class="lead">The principles that guide everything we do</p>
                </div>
                <div class="row g-4">
                    <div class="col-md-4 animate__animated animate__fadeIn" style="animation-delay: 0.1s;">
                        <div class="value-card">
                            <div class="value-icon" style="background-color: rgba(39, 107, 228, 0.1); color: #276BE4;">
                                <i class="fas fa-lightbulb"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Innovation</h4>
                            <p class="mb-0">We constantly push boundaries to create cutting-edge learning experiences that engage and inspire our students.</p>
                        </div>
                    </div>
                    <div class="col-md-4 animate__animated animate__fadeIn" style="animation-delay: 0.2s;">
                        <div class="value-card">
                            <div class="value-icon" style="background-color: rgba(255, 169, 21, 0.1); color: #FFA915;">
                                <i class="fas fa-hands-helping"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Accessibility</h4>
                            <p class="mb-0">We believe education should be available to everyone, regardless of background or circumstances.</p>
                        </div>
                    </div>
                    <div class="col-md-4 animate__animated animate__fadeIn" style="animation-delay: 0.3s;">
                        <div class="value-card">
                            <div class="value-icon" style="background-color: rgba(76, 175, 80, 0.1); color: #4CAF50;">
                                <i class="fas fa-medal"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Excellence</h4>
                            <p class="mb-0">We are committed to providing the highest quality educational content and experience.</p>
                        </div>
                    </div>
                </div>
            </div>

        
            
            <!-- Partners Section -->
            <div class="py-5 bg-light">
                <div class="container">
                    <div class="text-center mb-5">
                        <h2 class="fw-bold">Our Partners</h2>
                        <div class="accent-bar mx-auto mb-4" style="width: 60px; height: 3px; background: linear-gradient(90deg, #276BE4, #FFA915); border-radius: 2px;"></div>
                        <p class="lead">Collaborating with industry leaders to provide the best educational experience</p>
                    </div>
                    
                    <div class="row align-items-center justify-content-center g-4">
                        <!-- Partner logos with hover effects -->
                        <div class="col-6 col-md-3 col-lg-2 text-center">
                            <div class="partner-logo bg-white p-3 rounded-3 shadow-sm h-100 d-flex align-items-center justify-content-center" style="min-height: 100px;">
                                <img src="https://placehold.co/200x80?text=Partner+1" alt="Partner 1" class="img-fluid" style="max-height: 60px; filter: grayscale(100%); transition: all 0.3s ease;">
                            </div>
                        </div>
                        <div class="col-6 col-md-3 col-lg-2 text-center">
                            <div class="partner-logo bg-white p-3 rounded-3 shadow-sm h-100 d-flex align-items-center justify-content-center" style="min-height: 100px;">
                                <img src="https://placehold.co/200x80?text=Partner+2" alt="Partner 2" class="img-fluid" style="max-height: 60px; filter: grayscale(100%); transition: all 0.3s ease;">
                            </div>
                        </div>
                        <div class="col-6 col-md-3 col-lg-2 text-center">
                            <div class="partner-logo bg-white p-3 rounded-3 shadow-sm h-100 d-flex align-items-center justify-content-center" style="min-height: 100px;">
                                <img src="https://placehold.co/200x80?text=Partner+3" alt="Partner 3" class="img-fluid" style="max-height: 60px; filter: grayscale(100%); transition: all 0.3s ease;">
                            </div>
                        </div>
                        <div class="col-6 col-md-3 col-lg-2 text-center">
                            <div class="partner-logo bg-white p-3 rounded-3 shadow-sm h-100 d-flex align-items-center justify-content-center" style="min-height: 100px;">
                                <img src="https://placehold.co/200x80?text=Partner+4" alt="Partner 4" class="img-fluid" style="max-height: 60px; filter: grayscale(100%); transition: all 0.3s ease;">
                            </div>
                        </div>
                        <div class="col-6 col-md-3 col-lg-2 text-center">
                            <div class="partner-logo bg-white p-3 rounded-3 shadow-sm h-100 d-flex align-items-center justify-content-center" style="min-height: 100px;">
                                <img src="https://placehold.co/200x80?text=Partner+5" alt="Partner 5" class="img-fluid" style="max-height: 60px; filter: grayscale(100%); transition: all 0.3s ease;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <footer class="mt-5 position-relative">
        <!-- Top gradient bar -->
        <div class="position-absolute top-0 start-0 w-100" style="height: 4px; background: linear-gradient(90deg, #276BE4, #FFA915);"></div>
        
        <!-- Main footer content -->
        <div class="bg-white py-5">
            <div class="container">
                <div class="row gy-4">
                    <!-- Logo and description -->
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="mb-4">
                            <img src="/assets/images/logo.jpeg" alt="Panadite Academy" style="height: 50px;">
                        </div>
                        <p class="mb-2" style="color: #333; font-weight: 500;">Empowering learners through high-quality educational content.</p>
                        <p style="color: #333;">Get ahead of the curve with our premium videos and courses.</p>
                    </div>
                    
                    <!-- Quick links -->
                    <div class="col-lg-2 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3 pb-2 position-relative" style="color: #222;">
                            Quick Links
                            <span class="position-absolute bottom-0 start-0" style="height: 2px; width: 40px; background: #FFA915;"></span>
                        </h5>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="/index.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Home</a></li>
                            <li class="mb-2"><a href="/courses.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Courses</a></li>
                            <li class="mb-2"><a href="/videos.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Videos</a></li>
                            <li class="mb-2"><a href="/about.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>About Us</a></li>
                            <li class="mb-2"><a href="/contact.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Contact</a></li>
                        </ul>
                    </div>
                    
                    <!-- Facilitator links -->
                    <div class="col-lg-2 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3 pb-2 position-relative" style="color: #222;">
                            Facilitator
                            <span class="position-absolute bottom-0 start-0" style="height: 2px; width: 40px; background: #FFA915;"></span>
                        </h5>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="/auth/register.php?role=teacher" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Become a Facilitator</a></li>
                            <li class="mb-2"><a href="/teacher/dashboard.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Teacher Dashboard</a></li>
                            <li class="mb-2"><a href="/teacher/sales.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Your Sales</a></li>
                            <li class="mb-2"><a href="/teacher/help.php" class="text-decoration-none" style="color: #333;"><i class="fas fa-angle-right me-2" style="color: #276BE4;"></i>Teacher Help</a></li>
                        </ul>
                    </div>
                    
                    <!-- Contact info -->
                    <div class="col-lg-4 col-md-6">
                        <h5 class="fw-bold mb-3 pb-2 position-relative" style="color: #222;">
                            Contact
                            <span class="position-absolute bottom-0 start-0" style="height: 2px; width: 40px; background: #FFA915;"></span>
                        </h5>
                        <ul class="list-unstyled mb-4">
                            <li class="mb-3 d-flex align-items-center">
                                <span class="d-flex align-items-center justify-content-center me-3" style="width: 36px; height: 36px; background: rgba(39,107,228,0.1); border-radius: 50%;">
                                    <i class="fas fa-map-marker-alt" style="color: #276BE4;"></i>
                                </span>
                                <span style="color: #333;">296 Pretorius Street, Corner Lilian Ngoyi, Pretoria Central, 0001, South Africa</span>
                            </li>
                            <li class="mb-3 d-flex align-items-center">
                                <span class="d-flex align-items-center justify-content-center me-3" style="width: 36px; height: 36px; background: rgba(39,107,228,0.1); border-radius: 50%;">
                                    <i class="fas fa-envelope" style="color: #276BE4;"></i>
                                </span>
                                <a href="mailto:admin@panaditeacademy.com" class="text-decoration-none" style="color: #333;">admin@panaditeacademy.com</a>
                            </li>
                            <li class="mb-3 d-flex align-items-center">
                                <span class="d-flex align-items-center justify-content-center me-3" style="width: 36px; height: 36px; background: rgba(39,107,228,0.1); border-radius: 50%;">
                                    <i class="fas fa-phone" style="color: #276BE4;"></i>
                                </span>
                                <a href="tel:+27747223141" class="text-decoration-none" style="color: #333;">+27 74 722 3141</a>
                            </li>
                        </ul>
                        
                        <!-- Social icons -->
                        <div class="d-flex">
                            <a href="#" class="d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px; background: rgba(39,107,228,0.1); border-radius: 50%; color: #276BE4; transition: all 0.3s ease;">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px; background: rgba(39,107,228,0.1); border-radius: 50%; color: #276BE4; transition: all 0.3s ease;">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px; background: rgba(39,107,228,0.1); border-radius: 50%; color: #276BE4; transition: all 0.3s ease;">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="d-flex align-items-center justify-content-center" style="width: 40px; height: 40px; background: rgba(39,107,228,0.1); border-radius: 50%; color: #276BE4; transition: all 0.3s ease;">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Copyright section -->
        <div style="background: #f8f9fa; border-top: 1px solid #eee;" class="py-3">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-6 mb-3 mb-md-0">
                        <p class="mb-0" style="color: #333; font-weight: 500;">&copy; <?php echo date('Y'); ?> Panadite Academy. All rights reserved.</p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <a href="/privacy-policy.php" class="text-decoration-none me-3" style="color: #333;">Privacy Policy</a>
                        <a href="/terms.php" class="text-decoration-none me-3" style="color: #333;">Terms of Use</a>
                        <a href="/sitemap.php" class="text-decoration-none" style="color: #333;">Sitemap</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    
    
    <!-- Bootstrap JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
