<?php
/**
 * Advanced Session Fix for PHP Applications
 * 
 * This file ensures consistent session handling across all application parts
 * including API endpoints by standardizing session cookie parameters.
 */

// Only proceed if session isn't already active
if (session_status() == PHP_SESSION_NONE) {
    // Enhanced session configuration matching login.php EXACTLY
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    // Adjust secure flag based on HTTPS availability
    ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 1 : 0);
    ini_set('session.cookie_samesite', 'Lax');
    ini_set('session.use_strict_mode', 1);
    ini_set('session.cookie_lifetime', 7200); // 2 hours - MUST MATCH login.php
    ini_set('session.gc_maxlifetime', 7200); // 2 hours - MUST MATCH login.php
    ini_set('session.cookie_domain', ''); // Let PHP determine the domain
    ini_set('session.cookie_path', '/'); // Ensure cookie works for entire site

    // Set proper session save path for Linux server (same as login.php)
    $temp_dir = sys_get_temp_dir();
    if (!is_writable($temp_dir)) {
        // Try alternative paths for Linux server
        $alternative_paths = ['/tmp', '/var/tmp', dirname(__FILE__) . '/tmp'];
        foreach ($alternative_paths as $path) {
            if (is_dir($path) && is_writable($path)) {
                $temp_dir = $path;
                break;
            }
        }
    }
    ini_set('session.save_path', $temp_dir);
    error_log('DEBUG - Dashboard session save path set to: ' . $temp_dir);
    
    // 3. If we have a cookie but session isn't started, use that session ID
    $session_name = session_name();
    if (isset($_COOKIE[$session_name]) && !empty($_COOKIE[$session_name])) {
        session_id($_COOKIE[$session_name]);
    }
    
    // 4. Now start the session with all the correct parameters
    session_start();
    
    // 5. Set a timestamp for debugging (optional, can be removed in production)
    if (!isset($_SESSION['session_started_at'])) {
        $_SESSION['session_started_at'] = date('Y-m-d H:i:s');
    }
}
?>
