<?php
/**
 * PANADITE ACADEMY - COMPREHENSIVE ANALYTICS & SEO TRACKING
 * Includes Google Analytics, Search Console, and SEO monitoring
 */
?>

<!-- Google Analytics 4 (GA4) - Add your actual tracking ID -->
<script async src="https://www.googletagmanager.com/gtag/js?id=GA_MEASUREMENT_ID"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  // Configure Google Analytics
  gtag('config', 'GA_MEASUREMENT_ID', {
    page_title: document.title,
    page_location: window.location.href,
    custom_map: {
      'custom_parameter_1': 'course_category',
      'custom_parameter_2': 'user_type'
    }
  });

  // Enhanced E-commerce tracking for course purchases
  gtag('config', 'GA_MEASUREMENT_ID', {
    'custom_map.dimension1': 'course_category',
    'custom_map.dimension2': 'instructor_name',
    'custom_map.dimension3': 'course_difficulty'
  });
</script>

<!-- Google Tag Manager (Optional - for more advanced tracking) -->
<!-- 
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-XXXXXXX');</script>
-->

<!-- Facebook Pixel (for social media advertising) -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');

// Replace 'YOUR_PIXEL_ID' with your actual Facebook Pixel ID
fbq('init', 'YOUR_PIXEL_ID');
fbq('track', 'PageView');

// Course-specific tracking
function trackCourseView(courseId, courseName, courseCategory) {
  gtag('event', 'view_item', {
    currency: 'USD',
    value: 0,
    items: [{
      item_id: courseId,
      item_name: courseName,
      item_category: courseCategory,
      quantity: 1
    }]
  });
  
  fbq('track', 'ViewContent', {
    content_ids: [courseId],
    content_type: 'product',
    content_name: courseName,
    content_category: courseCategory
  });
}

// Course enrollment tracking
function trackCourseEnrollment(courseId, courseName, coursePrice, courseCategory) {
  gtag('event', 'purchase', {
    transaction_id: 'enrollment_' + Date.now(),
    value: coursePrice,
    currency: 'USD',
    items: [{
      item_id: courseId,
      item_name: courseName,
      item_category: courseCategory,
      quantity: 1,
      price: coursePrice
    }]
  });
  
  fbq('track', 'Purchase', {
    content_ids: [courseId],
    content_type: 'product',
    value: coursePrice,
    currency: 'USD'
  });
}

// Course completion tracking
function trackCourseCompletion(courseId, courseName, completionRate) {
  gtag('event', 'course_completed', {
    'custom_parameter_1': courseId,
    'custom_parameter_2': completionRate
  });
}

// Search tracking
function trackSiteSearch(searchTerm, resultsCount) {
  gtag('event', 'search', {
    search_term: searchTerm,
    custom_parameter_1: resultsCount
  });
}

// User registration tracking
function trackUserRegistration(userType) {
  gtag('event', 'sign_up', {
    method: 'email',
    custom_parameter_1: userType
  });
  
  fbq('track', 'CompleteRegistration');
}

// Newsletter signup tracking
function trackNewsletterSignup() {
  gtag('event', 'newsletter_signup');
  fbq('track', 'Subscribe');
}
</script>

<!-- Microsoft Clarity (for user behavior insights) -->
<script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "YOUR_CLARITY_PROJECT_ID");
</script>

<!-- LinkedIn Insight Tag (for B2B tracking) -->
<script type="text/javascript">
_linkedin_partner_id = "YOUR_LINKEDIN_PARTNER_ID";
window._linkedin_data_partner_ids = window._linkedin_data_partner_ids || [];
window._linkedin_data_partner_ids.push(_linkedin_partner_id);
</script><script type="text/javascript">
(function(l) {
if (!l){window.lintrk = function(a,b){window.lintrk.q.push([a,b])};
window.lintrk.q=[]}
var s = document.getElementsByTagName("script")[0];
var b = document.createElement("script");
b.type = "text/javascript";b.async = true;
b.src = "https://snap.licdn.com/li.js";
s.parentNode.insertBefore(b, s);})(window.lintrk);
</script>

<!-- Schema.org Structured Data for Better SEO -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebApplication",
  "name": "Panadite Academy",
  "url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>",
  "applicationCategory": "EducationalApplication",
  "operatingSystem": "Web",
  "offers": {
    "@type": "Offer",
    "category": "Educational Services",
    "priceRange": "$0-$500"
  },
  "aggregateRating": {
    "@type": "AggregateRating",
    "ratingValue": "4.8",
    "reviewCount": "2500"
  }
}
</script>

<!-- Hotjar Tracking (for user experience insights) -->
<script>
    (function(h,o,t,j,a,r){
        h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
        h._hjSettings={hjid:YOUR_HOTJAR_ID,hjsv:6};
        a=o.getElementsByTagName('head')[0];
        r=o.createElement('script');r.async=1;
        r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
        a.appendChild(r);
    })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
</script>

<!-- Additional SEO and Performance Tracking -->
<script>
// Performance monitoring for SEO
window.addEventListener('load', function() {
  setTimeout(function() {
    const perfData = performance.getEntriesByType('navigation')[0];
    
    if (typeof gtag !== 'undefined') {
      gtag('event', 'page_load_time', {
        'custom_parameter_1': Math.round(perfData.loadEventEnd - perfData.loadEventStart),
        'custom_parameter_2': Math.round(perfData.domContentLoadedEventEnd - perfData.domContentLoadedEventStart)
      });
    }
  }, 1000);
});

// Scroll depth tracking for engagement
let maxScroll = 0;
window.addEventListener('scroll', function() {
  const scrollPercent = Math.round((window.scrollY / (document.body.scrollHeight - window.innerHeight)) * 100);
  if (scrollPercent > maxScroll) {
    maxScroll = scrollPercent;
    
    if (maxScroll >= 25 && maxScroll < 50) {
      if (typeof gtag !== 'undefined') gtag('event', 'scroll_25');
    } else if (maxScroll >= 50 && maxScroll < 75) {
      if (typeof gtag !== 'undefined') gtag('event', 'scroll_50');
    } else if (maxScroll >= 75 && maxScroll < 90) {
      if (typeof gtag !== 'undefined') gtag('event', 'scroll_75');
    } else if (maxScroll >= 90) {
      if (typeof gtag !== 'undefined') gtag('event', 'scroll_90');
    }
  }
});

// Outbound link tracking
document.addEventListener('click', function(e) {
  if (e.target.tagName === 'A' && e.target.hostname !== window.location.hostname) {
    if (typeof gtag !== 'undefined') {
      gtag('event', 'click', {
        event_category: 'outbound',
        event_label: e.target.href,
        transport_type: 'beacon'
      });
    }
  }
});
</script>

<!-- JSON-LD for Course Organization -->
<?php if (isset($course) && is_array($course)): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Course",
  "name": "<?php echo htmlspecialchars($course['title'] ?? ''); ?>",
  "description": "<?php echo htmlspecialchars($course['description'] ?? ''); ?>",
  "provider": {
    "@type": "Organization",
    "name": "Panadite Academy",
    "sameAs": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>"
  },
  "hasCourseInstance": {
    "@type": "CourseInstance",
    "courseMode": "online",
    "instructor": {
      "@type": "Person",
      "name": "<?php echo htmlspecialchars($course['instructor_name'] ?? 'Expert Instructor'); ?>"
    }
  }
}
</script>
<?php endif; ?>
