<?php
// Include database connection
require_once '../config/db_connect.php';

// SQL to create teacher_settings table if it doesn't exist
$sql = "CREATE TABLE IF NOT EXISTS teacher_settings (
  id INT PRIMARY KEY AUTO_INCREMENT,
  user_id INT NOT NULL,
  email_notifications TINYINT(1) DEFAULT 1,
  sms_notifications TINYINT(1) DEFAULT 0,
  dashboard_theme VARCHAR(20) DEFAULT 'light',
  timezone VARCHAR(50) DEFAULT 'UTC',
  language VARCHAR(10) DEFAULT 'en',
  enable_2fa TINYINT(1) DEFAULT 0,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
)";

// Execute the query
if ($conn->query($sql) === TRUE) {
    echo "Table 'teacher_settings' created successfully or already exists.<br>";
    
    // Check if there are any teachers without settings and create default settings for them
    $find_teachers = "SELECT u.id FROM users u 
                     LEFT JOIN teacher_settings ts ON u.id = ts.user_id 
                     WHERE u.role = 'teacher' AND ts.id IS NULL";
    
    $result = $conn->query($find_teachers);
    
    if ($result && $result->num_rows > 0) {
        echo "Creating default settings for " . $result->num_rows . " teachers:<br>";
        
        // Prepare the insert statement
        $insert_stmt = $conn->prepare("INSERT INTO teacher_settings 
                                    (user_id, email_notifications, sms_notifications, dashboard_theme, timezone, language, enable_2fa) 
                                    VALUES (?, 1, 0, 'light', 'UTC', 'en', 0)");
        
        $insert_stmt->bind_param("i", $teacher_id);
        
        while ($row = $result->fetch_assoc()) {
            $teacher_id = $row['id'];
            $insert_stmt->execute();
            echo "- Created settings for teacher ID: " . $teacher_id . "<br>";
        }
        
        echo "Default settings creation complete.<br>";
    } else {
        echo "All teachers already have settings entries.<br>";
    }
} else {
    echo "Error creating table: " . $conn->error;
}

$conn->close();
echo "Database connection closed.<br>";
echo "<a href='../teacher/settings.php'>Return to Settings Page</a>";
?>
