-- SQL Script to create teacher_settings table
CREATE TABLE IF NOT EXISTS teacher_settings (
  id INT PRIMARY KEY AUTO_INCREMENT,
  user_id INT NOT NULL,
  email_notifications TINYINT(1) DEFAULT 1,
  sms_notifications TINYINT(1) DEFAULT 0,
  dashboard_theme VARCHAR(20) DEFAULT 'light',
  timezone VARCHAR(50) DEFAULT 'UTC',
  language VARCHAR(10) DEFAULT 'en',
  enable_2fa TINYINT(1) DEFAULT 0,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Insert default settings for teachers who don't have settings yet
INSERT INTO teacher_settings (user_id, email_notifications, sms_notifications, dashboard_theme, timezone, language, enable_2fa)
SELECT u.id, 1, 0, 'light', 'UTC', 'en', 0
FROM users u
LEFT JOIN teacher_settings ts ON u.id = ts.user_id
WHERE u.role = 'teacher' AND ts.id IS NULL;
