<?php
/**
 * PANADITE ACADEMY - COMPREHENSIVE SEO HEADER
 * This file provides complete SEO optimization for maximum discoverability
 * Includes: Favicon, Meta Tags, Open Graph, Twitter Cards, Schema.org, and more
 */

// Default SEO values - can be overridden per page
$seo_title = $seo_title ?? 'Panadite Academy - Professional Online Learning Platform | Courses & Certifications';
$seo_description = $seo_description ?? 'Transform your career with Panadite Academy\'s professional online courses. Expert-led training, industry certifications, and hands-on learning. Join thousands of successful students worldwide.';
$seo_keywords = $seo_keywords ?? 'online courses, professional training, certifications, e-learning, skill development, career advancement, Panadite Academy, online education, professional development';
// Build absolute URL for logo (required for social media sharing)
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https' : 'http';
$domain = $protocol . '://' . $_SERVER['HTTP_HOST'];
$seo_image = $seo_image ?? $domain . '/logo.jpeg'; // FIXED: Use logo.jpeg from root directory
$seo_url = $seo_url ?? $domain . $_SERVER['REQUEST_URI'];
$seo_type = $seo_type ?? 'website';
$seo_site_name = $seo_site_name ?? 'Panadite Academy';

// Enhanced SEO variables for better optimization
$seo_author = $seo_author ?? 'Panadite Academy Team';
$seo_publisher = $seo_publisher ?? 'Panadite Academy';
$seo_theme_color = $seo_theme_color ?? '#276BE4'; // Brand blue color
?>

<!-- FAVICON AND APPLE TOUCH ICONS -->
<!-- Primary favicon - try standard favicon first -->
<link rel="icon" type="image/x-icon" href="/favicon.ico">
<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">

<!-- Fallback favicon using logo.jpeg -->
<link rel="icon" type="image/jpeg" href="/logo.jpeg">

<!-- Apple Touch Icons - using root logo.jpeg -->
<link rel="apple-touch-icon" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="57x57" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="60x60" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="72x72" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="76x76" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="114x114" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="120x120" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="144x144" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="152x152" href="/logo.jpeg">
<link rel="apple-touch-icon" sizes="180x180" href="/logo.jpeg">

<!-- Microsoft Tiles -->
<meta name="msapplication-TileImage" content="/logo.jpeg">
<meta name="msapplication-TileColor" content="<?php echo $seo_theme_color; ?>">
<meta name="theme-color" content="<?php echo $seo_theme_color; ?>">

<!-- ESSENTIAL META TAGS -->
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<!-- SEO META TAGS -->
<title><?php echo htmlspecialchars($seo_title); ?></title>
<meta name="description" content="<?php echo htmlspecialchars($seo_description); ?>">
<meta name="keywords" content="<?php echo htmlspecialchars($seo_keywords); ?>">
<meta name="author" content="Panadite Academy">
<meta name="robots" content="index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1">
<meta name="googlebot" content="index, follow">
<meta name="bingbot" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="distribution" content="global">
<meta name="rating" content="general">

<!-- OPEN GRAPH META TAGS (Facebook, WhatsApp, LinkedIn, Messenger) -->
<meta property="og:title" content="<?php echo htmlspecialchars($seo_title); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($seo_description); ?>">
<meta property="og:image" content="<?php echo htmlspecialchars($seo_image); ?>">
<meta property="og:image:secure_url" content="<?php echo htmlspecialchars($seo_image); ?>">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:image:alt" content="Panadite Academy - Professional Online Learning Platform">
<meta property="og:image:type" content="image/jpeg">
<meta property="og:url" content="<?php echo htmlspecialchars($seo_url); ?>">
<meta property="og:type" content="<?php echo htmlspecialchars($seo_type); ?>">
<meta property="og:site_name" content="<?php echo htmlspecialchars($seo_site_name); ?>">
<meta property="og:locale" content="en_US">
<meta property="og:locale:alternate" content="en_GB">
<meta property="og:updated_time" content="<?php echo date('c'); ?>">
<!-- Additional Open Graph tags for education -->
<meta property="og:email" content="info@panaditeacademy.com">
<meta property="og:phone_number" content="+27-XXX-XXX-XXXX">
<meta property="og:latitude" content="-26.2041">
<meta property="og:longitude" content="28.0473">

<!-- TWITTER CARD META TAGS (Enhanced for better sharing) -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo htmlspecialchars($seo_title); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($seo_description); ?>">
<meta name="twitter:image" content="<?php echo htmlspecialchars($seo_image); ?>">
<meta name="twitter:image:alt" content="Panadite Academy - Professional Online Learning Platform">
<meta name="twitter:site" content="@PanaditeAcademy">
<meta name="twitter:creator" content="@PanaditeAcademy">
<meta name="twitter:domain" content="<?php echo $_SERVER['HTTP_HOST']; ?>">
<meta name="twitter:url" content="<?php echo htmlspecialchars($seo_url); ?>">

<!-- ADDITIONAL SOCIAL PLATFORM META TAGS -->
<meta property="article:publisher" content="https://www.facebook.com/PanaditeAcademy">
<meta property="article:author" content="<?php echo htmlspecialchars($seo_author); ?>">
<meta name="pinterest-rich-pin" content="true">
<meta name="linkedin:owner" content="PanaditeAcademy">

<!-- WHATSAPP OPTIMIZATION -->
<meta property="og:image:secure_url" content="<?php echo str_replace('http:', 'https:', $seo_image); ?>">
<meta property="og:video:secure_url" content="">

<!-- TELEGRAM OPTIMIZATION -->
<meta name="telegram:channel" content="@PanaditeAcademy">

<!-- CANONICAL URL -->
<link rel="canonical" href="<?php echo htmlspecialchars($seo_url); ?>">

<!-- ADVANCED SEO OPTIMIZATION -->
<meta name="format-detection" content="telephone=no">
<meta name="format-detection" content="date=no">
<meta name="format-detection" content="address=no">
<meta name="format-detection" content="email=no">

<!-- DNS PREFETCH FOR PERFORMANCE -->
<link rel="dns-prefetch" href="//fonts.googleapis.com">
<link rel="dns-prefetch" href="//fonts.gstatic.com">
<link rel="dns-prefetch" href="//cdn.jsdelivr.net">
<link rel="dns-prefetch" href="//cdnjs.cloudflare.com">

<!-- PRECONNECT FOR CRITICAL RESOURCES -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<!-- ADDITIONAL LINK RELATIONS -->
<link rel="manifest" href="/manifest.json">
<link rel="sitemap" type="application/xml" href="/sitemap.xml">

<!-- VERIFY OWNERSHIP (Add actual verification codes when available) -->
<!-- <meta name="google-site-verification" content="YOUR_GOOGLE_VERIFICATION_CODE"> -->
<!-- <meta name="msvalidate.01" content="YOUR_BING_VERIFICATION_CODE"> -->
<!-- <meta name="yandex-verification" content="YOUR_YANDEX_VERIFICATION_CODE"> -->

<!-- STRUCTURED DATA (Schema.org) -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "EducationalOrganization",
  "name": "Panadite Academy",
  "alternateName": "Panadite",
  "url": "<?php echo htmlspecialchars(rtrim($seo_url, '/')); ?>",
  "logo": "<?php echo htmlspecialchars($seo_image); ?>",
  "description": "<?php echo htmlspecialchars($seo_description); ?>",
  "sameAs": [
    "https://www.facebook.com/PanaditeAcademy",
    "https://www.twitter.com/PanaditeAcademy",
    "https://www.linkedin.com/company/panadite-academy",
    "https://www.youtube.com/c/PanaditeAcademy"
  ],
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "",
    "contactType": "customer service",
    "availableLanguage": "English"
  },
  "address": {
    "@type": "PostalAddress",
    "addressCountry": "Global"
  },
  "aggregateRating": {
    "@type": "AggregateRating",
    "ratingValue": "4.8",
    "reviewCount": "2500"
  },
  "offers": {
    "@type": "AggregateOffer",
    "category": "Education",
    "priceRange": "R0 - R1500"
  }
}
</script>

<!-- WEBSITE STRUCTURED DATA -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "name": "Panadite Academy",
  "url": "<?php echo htmlspecialchars(rtrim($seo_url, '/')); ?>",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "<?php echo htmlspecialchars(rtrim($seo_url, '/')); ?>/search.php?q={search_term_string}",
    "query-input": "required name=search_term_string"
  }
}
</script>

<!-- COURSE STRUCTURED DATA (if on course page) -->
<?php if (isset($course) && is_array($course)): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Course",
  "name": "<?php echo htmlspecialchars($course['title'] ?? 'Professional Course'); ?>",
  "description": "<?php echo htmlspecialchars($course['description'] ?? $seo_description); ?>",
  "provider": {
    "@type": "EducationalOrganization",
    "name": "Panadite Academy",
    "url": "<?php echo htmlspecialchars(rtrim($seo_url, '/')); ?>"
  },
  "courseCode": "<?php echo htmlspecialchars($course['course_id'] ?? 'PA-COURSE'); ?>",
  "educationalLevel": "Professional",
  "teaches": "<?php echo htmlspecialchars($course['title'] ?? 'Professional Skills'); ?>",
  "offers": {
    "@type": "Offer",
    "price": "<?php echo htmlspecialchars($course['price'] ?? '0'); ?>",
    "priceCurrency": "USD"
  }
}
</script>
<?php endif; ?>

<!-- BREADCRUMB STRUCTURED DATA (if breadcrumbs exist) -->
<?php if (isset($breadcrumbs) && is_array($breadcrumbs)): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    <?php foreach ($breadcrumbs as $index => $breadcrumb): ?>
    {
      "@type": "ListItem",
      "position": <?php echo $index + 1; ?>,
      "name": "<?php echo htmlspecialchars($breadcrumb['name']); ?>",
      "item": "<?php echo htmlspecialchars($breadcrumb['url']); ?>"
    }<?php echo ($index < count($breadcrumbs) - 1) ? ',' : ''; ?>
    <?php endforeach; ?>
  ]
}
</script>
<?php endif; ?>

<!-- PRECONNECT FOR PERFORMANCE -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link rel="preconnect" href="https://cdnjs.cloudflare.com">

<!-- DNS PREFETCH -->
<link rel="dns-prefetch" href="//fonts.googleapis.com">
<link rel="dns-prefetch" href="//fonts.gstatic.com">
<link rel="dns-prefetch" href="//cdnjs.cloudflare.com">
<link rel="dns-prefetch" href="//cdn.jsdelivr.net">

<!-- THEME COLOR -->
<meta name="theme-color" content="#276BE4">
<meta name="msapplication-navbutton-color" content="#276BE4">
<meta name="apple-mobile-web-app-status-bar-style" content="#276BE4">

<!-- PWA MANIFEST -->
<link rel="manifest" href="/manifest.json">

<!-- GOOGLE SITE VERIFICATION (Add your actual verification code) -->
<!-- <meta name="google-site-verification" content="YOUR_GOOGLE_VERIFICATION_CODE"> -->

<!-- BING SITE VERIFICATION (Add your actual verification code) -->
<!-- <meta name="msvalidate.01" content="YOUR_BING_VERIFICATION_CODE"> -->

<!-- YANDEX SITE VERIFICATION (Add your actual verification code) -->
<!-- <meta name="yandex-verification" content="YOUR_YANDEX_VERIFICATION_CODE"> -->
