<?php
require_once "config/db_connect.php";

// Insert default categories
$sql = "
    INSERT INTO `categories` (`category_name`, `description`) VALUES
    ('Programming', 'Learn to code with various programming languages'),
    ('Mathematics', 'Explore the world of numbers, patterns, and formulas'),
    ('Business', 'Develop business skills and entrepreneurship'),
    ('Science', 'Discover the wonders of the physical and natural world'),
    ('Languages', 'Learn new languages and communication skills'),
    ('Technology', 'Explore cutting-edge tech and digital skills'),
    ('Arts & Creativity', 'Express yourself through various art forms')
";

if ($conn->query($sql) === TRUE) {
    echo "Default categories inserted successfully!";
} else {
    echo "Error inserting categories: " . $conn->error;
}

// Display all categories
$categories = $conn->query("SELECT * FROM categories ORDER BY category_id");
if ($categories->num_rows > 0) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Category Name</th></tr>";
    
    while($row = $categories->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['category_id'] . "</td>";
        echo "<td>" . $row['category_name'] . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
}
?>
