<?php
/**
 * PayFast ITN (Instant Transaction Notification) Handler
 * Panadite Academy
 */
require_once '../includes/config.php';
require_once '../config/db_connect.php';
require_once 'payfast.php';

// Verify that the request is from PayFast
$pfData = $_POST;

if (empty($pfData)) {
    error_log('PayFast Notification: No POST data received');
    header('HTTP/1.0 400 Bad Request');
    exit();
}

// Verify the ITN data
if (verifyPayfastItn($pfData)) {
    // Process the successful payment
    if (processSuccessfulPayment($pfData)) {
        // Log success
        error_log('PayFast Payment Successful: ' . $pfData['pf_payment_id']);
        
        // Return 200 OK to PayFast
        header('HTTP/1.0 200 OK');
        echo 'OK';
        exit();
    } else {
        // Log processing error
        error_log('PayFast Payment Processing Error: ' . $pfData['pf_payment_id']);
        header('HTTP/1.0 500 Internal Server Error');
        exit();
    }
} else {
    // Log verification failure
    error_log('PayFast Verification Failed: ' . json_encode($pfData));
    header('HTTP/1.0 400 Bad Request');
    exit();
}
?>
