<?php
// Simple PHP configuration checker and diagnostic tool
// This file should run even if you have PHP configuration issues

// Check for required extensions
$required_extensions = [
    'mysqli' => 'Required for database connectivity',
    'pdo_mysql' => 'Required for database connectivity',
    'gd' => 'Recommended for image processing',
    'fileinfo' => 'Recommended for file uploads'
];

$missing_extensions = [];
$installed_extensions = [];

foreach ($required_extensions as $ext => $desc) {
    if (extension_loaded($ext)) {
        $installed_extensions[$ext] = $desc;
    } else {
        $missing_extensions[$ext] = $desc;
    }
}

// Get PHP info
$php_version = phpversion();
$php_ini_path = php_ini_loaded_file();
$server_software = $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown';
$upload_max_filesize = ini_get('upload_max_filesize');
$post_max_size = ini_get('post_max_size');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP Configuration Check - Panadite Academy</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; margin: 20px; }
        h1 { color: #2c3e50; }
        .container { max-width: 800px; margin: 0 auto; }
        .card { border: 1px solid #ddd; border-radius: 4px; padding: 20px; margin-bottom: 20px; }
        .card h2 { margin-top: 0; color: #3498db; }
        .error { color: #e74c3c; }
        .success { color: #2ecc71; }
        .warning { color: #f39c12; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 10px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f8f9fa; }
        pre { background: #f8f9fa; padding: 10px; overflow-x: auto; }
        .btn { 
            display: inline-block;
            padding: 10px 15px;
            background: #3498db;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>PHP Configuration Check</h1>
        <p>This tool helps diagnose issues with your PHP configuration for Panadite Academy.</p>
        
        <div class="card">
            <h2>PHP Environment</h2>
            <table>
                <tr>
                    <th>PHP Version</th>
                    <td><?php echo $php_version; ?></td>
                </tr>
                <tr>
                    <th>PHP.ini Location</th>
                    <td><?php echo $php_ini_path ? $php_ini_path : 'Not found'; ?></td>
                </tr>
                <tr>
                    <th>Server Software</th>
                    <td><?php echo $server_software; ?></td>
                </tr>
                <tr>
                    <th>Upload Max Filesize</th>
                    <td><?php echo $upload_max_filesize; ?></td>
                </tr>
                <tr>
                    <th>Post Max Size</th>
                    <td><?php echo $post_max_size; ?></td>
                </tr>
            </table>
        </div>
        
        <?php if (!empty($missing_extensions)): ?>
        <div class="card">
            <h2 class="error">Missing Required Extensions</h2>
            <p>The following PHP extensions are required but not enabled on your server:</p>
            <ul>
                <?php foreach ($missing_extensions as $ext => $desc): ?>
                <li><strong><?php echo $ext; ?></strong> - <?php echo $desc; ?></li>
                <?php endforeach; ?>
            </ul>
            
            <h3>How to Enable Extensions</h3>
            <p>Follow these steps to enable the missing extensions:</p>
            <ol>
                <li>Locate your php.ini file at: <code><?php echo $php_ini_path ? $php_ini_path : 'Not found - run php --ini in command prompt to locate'; ?></code></li>
                <li>Open the file in a text editor</li>
                <li>Find and uncomment these lines by removing the semicolon:</li>
                <pre>
<?php foreach ($missing_extensions as $ext => $desc): ?>
;extension=<?php echo $ext; ?>   →   extension=<?php echo $ext; ?>
<?php endforeach; ?>
                </pre>
                <li>Save the file and restart your web server</li>
            </ol>
        </div>
        <?php else: ?>
        <div class="card">
            <h2 class="success">All Required Extensions Installed</h2>
            <p>Your PHP installation has all required extensions enabled.</p>
            <ul>
                <?php foreach ($installed_extensions as $ext => $desc): ?>
                <li><strong><?php echo $ext; ?></strong> - <?php echo $desc; ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endif; ?>
        
        <div class="card">
            <h2>Temporary Workarounds</h2>
            <p>While you're setting up your PHP configuration, you can use these workarounds:</p>
            <p><a href="standalone-upload.php" class="btn">Use Standalone Video Uploader</a></p>
            <p>The standalone uploader doesn't require database connectivity and allows you to test video uploads.</p>
        </div>
    </div>
</body>
</html>
