<?php
// Force proper session configuration to match CMS system
ini_set('session.save_handler', 'files');
ini_set('session.save_path', '/tmp');
ini_set('session.use_cookies', 1);
ini_set('session.cookie_lifetime', 0);
ini_set('session.cookie_path', '/');
ini_set('session.cookie_domain', '');
ini_set('session.cookie_secure', 0);
ini_set('session.cookie_httponly', 1);

session_start();
require_once 'config/db_connect.php';

// Include CMS functions only if file exists (for production compatibility)
$cms_enabled = false;
if (file_exists('cms/functions/cms_functions.php')) {
    require_once 'cms/functions/cms_functions.php';
    $cms_enabled = true;
} else {
    // Fallback cms function when CMS is not available
    function cms($page_name, $section_key, $default_content = '') {
        return $default_content;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - Panadite Academy</title>
    <meta name="description" content="Learn how Panadite Academy collects, uses, and protects your personal information. Our comprehensive privacy policy ensures your data security and transparency.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #276BE4;
            --primary-amber: #FFA915;
            --dark-text: #2d3748;
            --light-text: #718096;
            --bg-light: #f8f9fa;
            --border-color: #e2e8f0;
            --success-green: #10b981;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: #ffffff;
            color: var(--dark-text);
            line-height: 1.6;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--dark-text);
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(39, 107, 228, 0.03) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 169, 21, 0.03) 0%, transparent 50%);
            animation: backgroundPulse 8s ease-in-out infinite alternate;
        }
        
        @keyframes backgroundPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.8; }
        }
        
        .floating-element {
            position: absolute;
            pointer-events: none;
            opacity: 0.1;
        }
        
        .floating-element:nth-child(1) {
            top: 15%;
            left: 10%;
            animation: float1 7s ease-in-out infinite;
        }
        
        .floating-element:nth-child(2) {
            top: 60%;
            right: 15%;
            animation: float2 9s ease-in-out infinite reverse;
        }
        
        .floating-element:nth-child(3) {
            bottom: 25%;
            left: 75%;
            animation: float3 6s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(25px, -20px) rotate(180deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(-30px, -25px) rotate(-180deg); }
        }
        
        @keyframes float3 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(20px, 25px) rotate(360deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }
        
        .hero-content h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            line-height: 1.2;
            color: var(--dark-text);
            animation: fadeInUp 1s ease-out 0.2s both;
        }
        
        .hero-content p {
            font-size: 1.1rem;
            color: var(--light-text);
            margin-bottom: 2rem;
            max-width: 600px;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .content-section {
            padding: 2rem 0;
        }
        
        .policy-card {
            background: white;
            border-radius: 16px;
            padding: 3rem 2.5rem;
            margin-bottom: 3rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(30px);
            animation: slideInUp 0.6s ease-out forwards;
        }
        
        .policy-card:nth-child(1) { animation-delay: 0.1s; }
        .policy-card:nth-child(2) { animation-delay: 0.2s; }
        .policy-card:nth-child(3) { animation-delay: 0.3s; }
        .policy-card:nth-child(4) { animation-delay: 0.4s; }
        
        @keyframes slideInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .policy-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 40px rgba(39, 107, 228, 0.15);
            border-color: rgba(39, 107, 228, 0.2);
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            padding-left: 0.5rem;
        }
        
        .section-title i {
            background: var(--primary-blue);
            color: white;
            width: 45px;
            height: 45px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            font-size: 1.1rem;
        }
        
        .policy-content {
            color: var(--dark-text);
            line-height: 1.7;
        }
        
        .policy-content h3 {
            color: var(--primary-blue);
            font-size: 1.2rem;
            font-weight: 600;
            margin: 1.5rem 0 1rem;
        }
        
        .policy-content ul {
            padding-left: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .policy-content li {
            margin-bottom: 0.5rem;
            color: var(--light-text);
        }
        
        .policy-content strong {
            color: var(--dark-text);
        }
        
        .back-btn {
            background: white;
            color: var(--primary-blue);
            border: 1px solid var(--border-color);
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .back-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }
        
        .back-btn i {
            margin-right: 0.5rem;
        }
        
        .last-updated {
            background: var(--bg-light);
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
            border-left: 4px solid var(--primary-blue);
        }
        
        .last-updated strong {
            color: var(--primary-blue);
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <section class="hero-section">
        <!-- Floating animated elements -->
        <div class="floating-element">
            <i class="fas fa-shield-alt" style="font-size: 50px; color: var(--primary-blue);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-lock" style="font-size: 42px; color: var(--success-green);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-user-shield" style="font-size: 38px; color: var(--primary-amber);"></i>
        </div>
        
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1><?= cms('privacy', 'hero_title', 'Privacy Policy') ?></h1>
                        <p><?= cms('privacy', 'hero_description', 'Your privacy is important to us. This policy explains how Panadite Academy collects, uses, and protects your personal information when you use our educational platform.') ?></p>
                    </div>
                </div>
                <div class="col-lg-4 text-center">
                    <div style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border: 1px solid var(--border-color);">
                        <i class="fas fa-shield-alt" style="font-size: 3rem; margin-bottom: 1rem; color: var(--primary-blue);"></i>
                        <h4 style="margin: 0; font-weight: 700; color: var(--dark-text);"><?= cms('privacy', 'safety_card_title', 'Your Data is Safe') ?></h4>
                        <p style="margin: 0.5rem 0 0; color: var(--light-text); font-size: 0.95rem;"><?= cms('privacy', 'safety_card_description', 'We protect your privacy') ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Main Content -->
    <div class="container">
        <a href="index.php" class="back-btn">
            <i class="fas fa-arrow-left"></i>
            Back to Home
        </a>
        
        <div class="content-section">
            <!-- Information We Collect -->
            <div class="policy-card">
                <div class="section-title">
                    <i class="fas fa-info-circle"></i>
                    <?= cms('privacy', 'info_collect_title', 'Information We Collect') ?>
                </div>
                <div class="policy-content">
                    <p><?= cms('privacy', 'info_collect_intro', 'We collect information to provide better services to our users. The types of information we collect include:') ?></p>
                    
                    <h3><?= cms('privacy', 'personal_info_title', 'Personal Information') ?></h3>
                    <ul>
                        <li><strong>Account Information:</strong> <?= cms('privacy', 'account_info_desc', 'Name, email address, password, and profile information') ?></li>
                        <li><strong>Payment Information:</strong> <?= cms('privacy', 'payment_info_desc', 'Billing details and payment method information (processed securely through third-party providers)') ?></li>
                        <li><strong>Educational Progress:</strong> <?= cms('privacy', 'education_progress_desc', 'Course enrollments, progress, grades, and certificates earned') ?></li>
                        <li><strong>Communication Data:</strong> <?= cms('privacy', 'communication_data_desc', 'Messages, support tickets, and feedback you provide') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'usage_info_title', 'Usage Information') ?></h3>
                    <ul>
                        <li><strong>Device Information:</strong> <?= cms('privacy', 'device_info_desc', 'Device type, operating system, browser information') ?></li>
                        <li><strong>Log Data:</strong> <?= cms('privacy', 'log_data_desc', 'IP address, access times, pages viewed, and actions taken') ?></li>
                        <li><strong>Learning Analytics:</strong> <?= cms('privacy', 'learning_analytics_desc', 'Time spent on courses, video watch time, quiz attempts') ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- How We Use Information -->
            <div class="policy-card">
                <div class="section-title">
                    <i class="fas fa-cogs"></i>
                    <?= cms('privacy', 'how_we_use_title', 'How We Use Your Information') ?>
                </div>
                <div class="policy-content">
                    <p><?= cms('privacy', 'how_we_use_intro', 'We use the information we collect to:') ?></p>
                    
                    <h3><?= cms('privacy', 'educational_services_title', 'Provide Educational Services') ?></h3>
                    <ul>
                        <li><?= cms('privacy', 'manage_account_desc', 'Create and manage your account') ?></li>
                        <li><?= cms('privacy', 'deliver_courses_desc', 'Deliver courses and track your progress') ?></li>
                        <li><?= cms('privacy', 'issue_certificates_desc', 'Issue certificates and credentials') ?></li>
                        <li><?= cms('privacy', 'process_payments_desc', 'Process payments and manage subscriptions') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'improve_platform_title', 'Improve Our Platform') ?></h3>
                    <ul>
                        <li><?= cms('privacy', 'analyze_usage_desc', 'Analyze usage patterns to enhance user experience') ?></li>
                        <li><?= cms('privacy', 'develop_features_desc', 'Develop new features and content') ?></li>
                        <li><?= cms('privacy', 'troubleshoot_desc', 'Troubleshoot technical issues') ?></li>
                        <li><?= cms('privacy', 'conduct_research_desc', 'Conduct research and analytics') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'communication_title', 'Communication') ?></h3>
                    <ul>
                        <li><?= cms('privacy', 'course_updates_desc', 'Send course updates and educational content') ?></li>
                        <li><?= cms('privacy', 'customer_support_desc', 'Provide customer support') ?></li>
                        <li><?= cms('privacy', 'account_notifications_desc', 'Send important account notifications') ?></li>
                        <li><?= cms('privacy', 'promotional_content_desc', 'Share relevant promotional content (with your consent)') ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- Information Sharing -->
            <div class="policy-card">
                <div class="section-title">
                    <i class="fas fa-share-alt"></i>
                    <?= cms('privacy', 'info_sharing_title', 'Information Sharing and Disclosure') ?>
                </div>
                <div class="policy-content">
                    <p><?= cms('privacy', 'info_sharing_intro', 'We do not sell, trade, or rent your personal information to third parties. We may share your information only in the following circumstances:') ?></p>
                    
                    <h3><?= cms('privacy', 'service_providers_title', 'Service Providers') ?></h3>
                    <ul>
                        <li><strong>Payment Processors:</strong> <?= cms('privacy', 'payment_processors_desc', 'To process payments securely') ?></li>
                        <li><strong>Email Services:</strong> <?= cms('privacy', 'email_services_desc', 'To send course notifications and updates') ?></li>
                        <li><strong>Analytics Providers:</strong> <?= cms('privacy', 'analytics_providers_desc', 'To understand platform usage (anonymized data only)') ?></li>
                        <li><strong>Cloud Storage:</strong> <?= cms('privacy', 'cloud_storage_desc', 'To securely store course content and data') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'legal_requirements_title', 'Legal Requirements') ?></h3>
                    <ul>
                        <li><?= cms('privacy', 'legal_process_desc', 'When required by law or legal process') ?></li>
                        <li><?= cms('privacy', 'protect_rights_desc', 'To protect our rights and safety') ?></li>
                        <li><?= cms('privacy', 'prevent_fraud_desc', 'To prevent fraud or abuse') ?></li>
                        <li><?= cms('privacy', 'business_transfers_desc', 'In connection with business transfers (with notice to users)') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'with_consent_title', 'With Your Consent') ?></h3>
                    <p><?= cms('privacy', 'with_consent_desc', 'We will share your information with third parties only when you provide explicit consent for specific purposes.') ?></p>
                </div>
            </div>
            
            <!-- Data Security -->
            <div class="policy-card">
                <div class="section-title">
                    <i class="fas fa-lock"></i>
                    <?= cms('privacy', 'data_security_title', 'Data Security and Protection') ?>
                </div>
                <div class="policy-content">
                    <p><?= cms('privacy', 'data_security_intro', 'We implement robust security measures to protect your personal information:') ?></p>
                    
                    <h3><?= cms('privacy', 'technical_safeguards_title', 'Technical Safeguards') ?></h3>
                    <ul>
                        <li><strong>Encryption:</strong> <?= cms('privacy', 'encryption_desc', 'All data is encrypted in transit and at rest') ?></li>
                        <li><strong>Secure Servers:</strong> <?= cms('privacy', 'secure_servers_desc', 'Data is stored on secure, monitored servers') ?></li>
                        <li><strong>Access Controls:</strong> <?= cms('privacy', 'access_controls_desc', 'Strict access controls limit who can view your data') ?></li>
                        <li><strong>Regular Updates:</strong> <?= cms('privacy', 'regular_updates_desc', 'Security systems are regularly updated and tested') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'your_rights_title', 'Your Rights') ?></h3>
                    <ul>
                        <li><strong>Access:</strong> <?= cms('privacy', 'access_right_desc', 'Request a copy of your personal data') ?></li>
                        <li><strong>Correction:</strong> <?= cms('privacy', 'correction_right_desc', 'Update or correct your information') ?></li>
                        <li><strong>Deletion:</strong> <?= cms('privacy', 'deletion_right_desc', 'Request deletion of your account and data') ?></li>
                        <li><strong>Portability:</strong> <?= cms('privacy', 'portability_right_desc', 'Export your data in a standard format') ?></li>
                        <li><strong>Opt-out:</strong> <?= cms('privacy', 'optout_right_desc', 'Unsubscribe from marketing communications') ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- Cookies and Tracking -->
            <div class="policy-card">
                <div class="section-title">
                    <i class="fas fa-cookie-bite"></i>
                    <?= cms('privacy', 'cookies_title', 'Cookies and Tracking Technologies') ?>
                </div>
                <div class="policy-content">
                    <p><?= cms('privacy', 'cookies_intro', 'We use cookies and similar technologies to enhance your experience:') ?></p>
                    
                    <h3><?= cms('privacy', 'types_cookies_title', 'Types of Cookies') ?></h3>
                    <ul>
                        <li><strong>Essential Cookies:</strong> <?= cms('privacy', 'essential_cookies_desc', 'Required for basic platform functionality') ?></li>
                        <li><strong>Analytics Cookies:</strong> <?= cms('privacy', 'analytics_cookies_desc', 'Help us understand how you use our platform') ?></li>
                        <li><strong>Preference Cookies:</strong> <?= cms('privacy', 'preference_cookies_desc', 'Remember your settings and preferences') ?></li>
                        <li><strong>Marketing Cookies:</strong> <?= cms('privacy', 'marketing_cookies_desc', 'Show relevant content (with your consent)') ?></li>
                    </ul>
                    
                    <h3><?= cms('privacy', 'managing_cookies_title', 'Managing Cookies') ?></h3>
                    <p><?= cms('privacy', 'managing_cookies_desc', 'You can control cookies through your browser settings. Note that disabling essential cookies may affect platform functionality.') ?></p>
                </div>
            </div>
            
            <!-- Contact Information -->
            <div class="policy-card">
                <div class="section-title">
                    <i class="fas fa-envelope"></i>
                    <?= cms('privacy', 'contact_title', 'Contact Us About Privacy') ?>
                </div>
                <div class="policy-content">
                    <p><?= cms('privacy', 'contact_intro', 'If you have questions about this privacy policy or how we handle your data, please contact us:') ?></p>
                    
                    <ul>
                        <li><strong>Email:</strong> <?= cms('privacy', 'contact_email', 'privacy@panaditeacademy.com') ?></li>
                        <li><strong>Address:</strong> <?= cms('privacy', 'contact_address', 'Panadite Academy, Privacy Department') ?></li>
                        <li><strong>Response Time:</strong> <?= cms('privacy', 'response_time', 'We will respond to privacy inquiries within 48 hours') ?></li>
                    </ul>
                    
                    <p><?= cms('privacy', 'data_protection_note', 'For data protection requests (access, deletion, etc.), please include your full name and email address associated with your account.') ?></p>
                </div>
            </div>
            
            <!-- Last Updated -->
            <div class="last-updated">
                <p><strong>Last Updated:</strong> <?= date('F j, Y') ?></p>
                <p><?= cms('privacy', 'policy_update_note', 'We may update this privacy policy from time to time. We will notify you of any material changes by email or through our platform.') ?></p>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <?php if ($cms_enabled && isAdminLoggedIn()): ?>
        <!-- Include inline editor styles and scripts for CMS admin -->
        <link rel="stylesheet" href="cms/assets/css/inline-editor.css">
        <script src="cms/assets/js/inline-editor.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Initialize inline editor
                if (typeof InlineEditor !== 'undefined') {
                    InlineEditor.init();
                }
            });
        </script>
    <?php endif; ?>
</body>
</html>
