<?php
/**
 * Resend Email Verification - Panadite Academy
 */

require_once __DIR__ . '/config/email_verification_service.php';
require_once __DIR__ . '/auth/functions.php';

// Check if already logged in
if (isLoggedIn()) {
    header('Location: /');
    exit();
}

$message = '';
$success = false;
$error = false;

// Handle resend request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    
    if (empty($email)) {
        $error = true;
        $message = 'Email address is required.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = true;
        $message = 'Invalid email format.';
    } else {
        $result = resendVerificationEmail($email);
        
        if ($result['success']) {
            $success = true;
            $message = 'Verification email has been resent! Please check your email.';
        } else {
            $error = true;
            $message = $result['message'];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resend Verification Email - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .resend-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            backdrop-filter: blur(10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: #4f46e5;
            text-decoration: none;
        }
        .btn-primary {
            background: linear-gradient(45deg, #4f46e5, #7c3aed);
            border: none;
            padding: 12px 30px;
            border-radius: 50px;
            transition: all 0.3s ease;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(79, 70, 229, 0.3);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="resend-card p-5">
                    <!-- Logo -->
                    <div class="text-center mb-4">
                        <a href="/" class="logo text-decoration-none">
                            <i class="bx bx-graduation"></i> Panadite Academy
                        </a>
                    </div>

                    <div class="text-center mb-4">
                        <i class="bx bx-envelope" style="font-size: 3rem; color: #4f46e5;"></i>
                        <h2 class="mt-3">Resend Verification Email</h2>
                        <p class="text-muted">
                            Enter your email address to receive a new verification link
                        </p>
                    </div>

                    <?php if ($success): ?>
                        <div class="alert alert-success" role="alert">
                            <i class="bx bx-check-circle"></i> <?= htmlspecialchars($message) ?>
                        </div>
                        <div class="text-center">
                            <a href="/auth/login.php" class="btn btn-outline-primary">
                                <i class="bx bx-log-in"></i> Go to Login
                            </a>
                        </div>
                    <?php else: ?>
                        <?php if ($error): ?>
                            <div class="alert alert-danger" role="alert">
                                <i class="bx bx-error"></i> <?= htmlspecialchars($message) ?>
                            </div>
                        <?php endif; ?>

                        <form method="post" action="resend-verification.php">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email Address</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bx bx-envelope"></i>
                                    </span>
                                    <input type="email" 
                                           class="form-control" 
                                           id="email" 
                                           name="email" 
                                           value="<?= isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '' ?>"
                                           placeholder="Enter your email address"
                                           required>
                                </div>
                                <small class="text-muted">
                                    Enter the same email address you used to register
                                </small>
                            </div>

                            <div class="d-grid gap-2 mb-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bx bx-send"></i> Resend Verification Email
                                </button>
                            </div>
                        </form>

                        <hr>

                        <div class="text-center">
                            <small class="text-muted">
                                Don't have an account? 
                                <a href="/auth/register.php" class="text-decoration-none">Register here</a>
                            </small>
                            <br>
                            <small class="text-muted">
                                Already verified? 
                                <a href="/auth/login.php" class="text-decoration-none">Login here</a>
                            </small>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
