# Email Verification Testing Guide - Panadite Academy

## 🚀 Setup Instructions

### 1. Database Setup
Run these scripts in order to set up the email verification system:

1. **Update Users Table**: Visit `/setup/update_users_table.php`
   - Adds `email_verified_at` column to users table
   - Sets existing users as verified

2. **Setup Email Verification**: Visit `/setup/setup_email_verification.php`
   - Creates `email_verifications` table
   - Validates SMTP configuration
   - Shows system status

### 2. SMTP Configuration
Ensure your SMTP settings are configured in the admin panel:
- **Host**: Your SMTP server (e.g., smtp.gmail.com)
- **Port**: Usually 587 for TLS or 465 for SSL
- **Username**: Your email address
- **Password**: Your email password or app-specific password
- **Encryption**: TLS or SSL

## 🧪 Testing Scenarios

### Test 1: New Student Registration
1. **Navigate to**: `/auth/register.php`
2. **Select Role**: Student
3. **Fill Form**:
   - Username: `testuser123`
   - Email: `your-test-email@example.com`
   - Password: `TestPass123!`
   - First Name: `Test`
   - Last Name: `User`
4. **Submit Form**
5. **Expected Result**: 
   - ✅ Success message with email verification instructions
   - ✅ Form hidden after submission
   - ✅ Links to resend email and login page

### Test 2: Email Reception
1. **Check Email Inbox** (including spam folder)
2. **Expected Email**:
   - ✅ Professional HTML template
   - ✅ Panadite Academy branding
   - ✅ Clear verification button
   - ✅ 10-minute expiry warning (enhanced security)
   - ✅ Contact information

### Test 3: Email Verification
1. **Click Verification Link** in email
2. **Expected Result**:
   - ✅ Redirects to `/verify-email.php`
   - ✅ Success message displayed
   - ✅ Account created automatically
   - ✅ User can login immediately

### Test 4: New Teacher Registration
1. **Navigate to**: `/auth/register.php`
2. **Select Role**: Facilitator (Teacher)
3. **Fill Additional Fields**:
   - Course Title: `Advanced Mathematics`
   - Course Description: `Comprehensive math course for advanced students`
   - Qualifications: `PhD in Mathematics, 10 years teaching experience`
4. **Complete Registration Process**
5. **Expected Result**:
   - ✅ Same verification process as student
   - ✅ Teacher profile created with additional data
   - ✅ Account pending admin approval message

### Test 5: Duplicate Email Prevention
1. **Try registering with existing email**
2. **Expected Result**:
   - ✅ Error message: "Email already registered"
   - ✅ No verification email sent

### Test 6: Expired Token Handling
1. **Wait 10+ minutes after registration** (or manually expire in database)
2. **Click verification link**
3. **Expected Result**:
   - ✅ Error message: "Invalid or expired verification token"
   - ✅ Link to resend verification

### Test 7: Resend Verification Email
1. **Navigate to**: `/resend-verification.php`
2. **Enter email address** with pending verification
3. **Submit form**
4. **Expected Result**:
   - ✅ New verification email sent
   - ✅ Success message displayed
   - ✅ Old verification token invalidated

### Test 8: Invalid Token Handling
1. **Modify verification URL** with invalid token
2. **Visit modified URL**
3. **Expected Result**:
   - ✅ Error message: "Invalid verification token"
   - ✅ Options to resend or contact support

## 🔍 Database Verification

### Check Email Verifications Table
```sql
SELECT * FROM email_verifications ORDER BY created_at DESC LIMIT 10;
```

**Expected Columns**:
- `verification_id`, `email`, `username`, `password_hash`
- `first_name`, `last_name`, `user_role`, `verification_token`
- `additional_data`, `expires_at`, `created_at`

### Check Users Table
```sql
SELECT user_id, username, email, email_verified_at, user_role, created_at 
FROM users 
ORDER BY created_at DESC LIMIT 10;
```

**Verify**:
- ✅ `email_verified_at` is set for verified users
- ✅ Role-specific profiles exist in student_profiles/teacher_profiles

## 🐛 Troubleshooting

### Email Not Received
1. **Check SMTP Configuration**: Visit admin panel
2. **Check Server Logs**: Look for email sending errors
3. **Test SMTP Connection**: Use setup script to verify
4. **Check Spam Folder**: Verification emails might be filtered

### Verification Link Not Working
1. **Check Token Format**: Should be 64-character hex string
2. **Check Expiry Time**: Tokens expire after 24 hours
3. **Check Database**: Verify record exists in email_verifications

### Account Not Created After Verification
1. **Check Error Logs**: Look for database errors
2. **Verify Database Permissions**: Ensure INSERT permissions
3. **Check Username/Email Uniqueness**: May conflict with existing users

### Database Connection Issues
1. **Check Database Configuration**: `/config/db_connect.php`
2. **Verify Database Exists**: Check if database is accessible
3. **Check User Permissions**: Ensure database user has proper rights

## 📊 Success Metrics

### Registration Flow
- ✅ **Registration Success Rate**: >95% of valid registrations should succeed
- ✅ **Email Delivery Rate**: >90% of emails should be delivered
- ✅ **Verification Completion**: >80% of sent emails should be verified

### User Experience
- ✅ **Clear Instructions**: Users understand next steps
- ✅ **Professional Emails**: HTML emails render correctly
- ✅ **Mobile Responsive**: Works on all device sizes
- ✅ **Fast Performance**: < 3 seconds for all operations

### Security
- ✅ **Token Security**: Cryptographically secure tokens
- ✅ **Expiry Enforcement**: Tokens expire after 24 hours
- ✅ **Duplicate Prevention**: No duplicate registrations
- ✅ **SQL Injection Protection**: All queries use prepared statements

## 🔧 Maintenance

### Daily Tasks
- Clean up expired verification tokens (automated)
- Monitor email delivery rates
- Check for failed verification attempts

### Weekly Tasks
- Review user registration analytics
- Update email templates if needed
- Monitor system performance

### Monthly Tasks
- Update security tokens if needed
- Review and update documentation
- Performance optimization review

---

## 📞 Support Information

If you encounter issues during testing:

1. **Check Logs**: Look in server error logs and application logs
2. **Database Status**: Verify all tables exist and have correct structure
3. **SMTP Status**: Test email configuration in admin panel
4. **Contact Support**: Document the specific error and steps to reproduce

**Happy Testing! 🎉**
