<?php
/**
 * SMTP Configuration Fix Tool - Panadite Academy
 * Fix the port 465/TLS mismatch issue
 */

require_once __DIR__ . '/../config/db_connect.php';

$success = false;
$error = '';

if ($_POST && isset($_POST['fix_smtp'])) {
    try {
        // Your current SMTP host
        $host = 'lon106b.superfasthost.cloud';
        $username = 'testme@panaditeacademy.com';
        $password = $_POST['smtp_password'] ?? ''; // You'll need to provide this
        
        // Correct configuration for port 465
        $settings = [
            'smtp_enabled' => '1',
            'smtp_host' => $host,
            'smtp_port' => '465',
            'smtp_encryption' => 'ssl', // Changed from 'tls' to 'ssl' for port 465
            'smtp_username' => $username,
            'smtp_password' => $password,
            'smtp_auth' => '1',
            'from_email' => $username,
            'from_name' => 'Panadite Academy'
        ];
        
        // Update database settings
        if ($pdo) {
            foreach ($settings as $key => $value) {
                $stmt = $pdo->prepare("INSERT INTO system_settings (setting_group, setting_key, setting_value) VALUES ('email', ?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            $success = true;
        }
        
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

// Get current settings
$currentSettings = [];
if ($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM system_settings WHERE setting_group = 'email'");
        $stmt->execute();
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($results as $row) {
            $currentSettings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (Exception $e) {
        // Continue
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fix SMTP Configuration - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card shadow">
                    <div class="card-header bg-warning text-dark">
                        <h4 class="mb-0"><i class="bx bx-wrench"></i> Fix SMTP Configuration</h4>
                    </div>
                    <div class="card-body">
                        
                        <div class="alert alert-danger">
                            <h6><i class="bx bx-error-circle"></i> Issues Found in Debug Output:</h6>
                            <ol>
                                <li><strong>Port 465 + TLS = Wrong Combination</strong><br>
                                    <small>Port 465 uses implicit SSL, not TLS/STARTTLS</small>
                                </li>
                                <li><strong>Broken Pipe Errors</strong><br>
                                    <small>STARTTLS commands failing on SSL port</small>
                                </li>
                                <li><strong>Native mail() Disabled</strong><br>
                                    <small>Your hosting provider disabled PHP mail function</small>
                                </li>
                            </ol>
                        </div>
                        
                        <?php if ($success): ?>
                            <div class="alert alert-success">
                                <h6><i class="bx bx-check-circle"></i> SMTP Configuration Fixed!</h6>
                                <p>Updated settings:</p>
                                <ul>
                                    <li><strong>Port:</strong> 465 (implicit SSL)</li>
                                    <li><strong>Encryption:</strong> SSL (not TLS)</li>
                                    <li><strong>Host:</strong> lon106b.superfasthost.cloud</li>
                                </ul>
                                <div class="mt-3">
                                    <a href="debug_email_deep.php" class="btn btn-success">
                                        <i class="bx bx-test-tube"></i> Test Fixed Configuration
                                    </a>
                                </div>
                            </div>
                        <?php elseif ($error): ?>
                            <div class="alert alert-danger">
                                <i class="bx bx-error-circle"></i> Error: <?php echo htmlspecialchars($error); ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5><i class="bx bx-bug"></i> Current (Broken) Configuration</h5>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <tr class="table-danger">
                                            <td><strong>SMTP Host</strong></td>
                                            <td><?php echo htmlspecialchars($currentSettings['smtp_host'] ?? 'Not set'); ?></td>
                                        </tr>
                                        <tr class="table-danger">
                                            <td><strong>Port</strong></td>
                                            <td><?php echo htmlspecialchars($currentSettings['smtp_port'] ?? 'Not set'); ?></td>
                                        </tr>
                                        <tr class="table-danger">
                                            <td><strong>Encryption</strong></td>
                                            <td><?php echo htmlspecialchars($currentSettings['smtp_encryption'] ?? 'Not set'); ?> ❌</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Username</strong></td>
                                            <td><?php echo htmlspecialchars($currentSettings['smtp_username'] ?? 'Not set'); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <h5><i class="bx bx-check"></i> Correct Configuration</h5>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <tr class="table-success">
                                            <td><strong>SMTP Host</strong></td>
                                            <td>lon106b.superfasthost.cloud</td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>Port</strong></td>
                                            <td>465</td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>Encryption</strong></td>
                                            <td>SSL (not TLS) ✅</td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>Username</strong></td>
                                            <td>testme@panaditeacademy.com</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <h5><i class="bx bx-wrench"></i> Apply Fix</h5>
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="smtp_password" class="form-label">SMTP Password</label>
                                <input type="password" class="form-control" id="smtp_password" name="smtp_password" 
                                       placeholder="Enter your SMTP password" required>
                                <div class="form-text">Your current SMTP password for testme@panaditeacademy.com</div>
                            </div>
                            
                            <div class="alert alert-info">
                                <h6><i class="bx bx-info-circle"></i> What This Fix Does:</h6>
                                <ul class="mb-0">
                                    <li>Changes encryption from <code>TLS</code> to <code>SSL</code> for port 465</li>
                                    <li>Prevents "Broken Pipe" STARTTLS errors</li>
                                    <li>Uses proper implicit SSL connection</li>
                                    <li>Updates database configuration automatically</li>
                                </ul>
                            </div>
                            
                            <button type="submit" name="fix_smtp" class="btn btn-warning btn-lg">
                                <i class="bx bx-wrench"></i> Fix SMTP Configuration Now
                            </button>
                        </form>
                        
                        <hr>
                        
                        <h5><i class="bx bx-help-circle"></i> Alternative Solutions</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h6 class="mb-0">Option 1: Use Port 587 (Recommended)</h6>
                                    </div>
                                    <div class="card-body small">
                                        <strong>Settings:</strong><br>
                                        • Port: 587<br>
                                        • Encryption: TLS<br>
                                        • More compatible with hosting providers
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">Option 2: Fix Port 465 (Current)</h6>
                                    </div>
                                    <div class="card-body small">
                                        <strong>Settings:</strong><br>
                                        • Port: 465<br>
                                        • Encryption: SSL (not TLS)<br>
                                        • Implicit SSL connection
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4 text-center">
                            <a href="debug_email_deep.php" class="btn btn-info">
                                <i class="bx bx-bug"></i> Run Debug Again
                            </a>
                            <a href="/auth/register.php" class="btn btn-success ms-2">
                                <i class="bx bx-user-plus"></i> Test Registration
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
