<?php
/**
 * Helper script to get all reminders for testing
 */

header('Content-Type: application/json');
require_once '../config/database.php';

try {
    $sql = "
        SELECT 
            sr.reminder_id,
            sr.student_id,
            sr.course_id,
            sr.reminder_date,
            sr.reminder_time,
            sr.reminder_type,
            sr.description,
            sr.email_sent,
            sr.reminder_sent,
            sr.is_completed,
            sr.created_at,
            u.first_name,
            u.last_name,
            u.email,
            c.title as course_title
        FROM study_reminders sr
        LEFT JOIN users u ON sr.student_id = u.user_id
        LEFT JOIN courses c ON sr.course_id = c.course_id
        ORDER BY sr.reminder_date DESC, sr.reminder_time DESC
        LIMIT 20
    ";
    
    $result = $conn->query($sql);
    $reminders = [];
    
    while ($row = $result->fetch_assoc()) {
        $reminders[] = $row;
    }
    
    echo json_encode([
        'success' => true,
        'reminders' => $reminders,
        'count' => count($reminders)
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>
