<?php
/**
 * Backend Setup Runner for Study Reminders System
 * This script actually performs the database setup
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

// Security check
$setup_password = "panadite2024"; // Should match the one in index.php

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['password']) || $input['password'] !== $setup_password) {
        throw new Exception('Invalid setup password');
    }
    
    if (!isset($input['action']) || $input['action'] !== 'setup') {
        throw new Exception('Invalid action');
    }
    
    // Include the actual setup script
    ob_start();
    include 'create_study_reminders_table.php';
    $setup_output = ob_get_clean();
    
    // Check if setup was successful by looking for success indicators
    $success = strpos($setup_output, '🎉 Study Reminders Database Setup Complete!') !== false;
    
    if ($success) {
        echo json_encode([
            'success' => true,
            'message' => 'Study reminders system setup completed successfully',
            'output' => $setup_output,
            'project_path' => dirname(__DIR__),
            'next_steps' => [
                'Set up cron job for automatic reminders',
                'Test the reminder creation system',
                'Configure email settings if needed'
            ]
        ]);
    } else {
        throw new Exception('Setup script execution failed: ' . $setup_output);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'error_details' => $setup_output ?? 'No output captured'
    ]);
}
?>
