<?php
require_once 'config/db_connect.php';

echo "<h3>🔍 Assignment Submissions File Column Check</h3>";

// Get just the file-related columns
$result = $conn->query("DESCRIBE assignment_submissions");
$fileColumns = [];

while ($row = $result->fetch_assoc()) {
    if (strpos($row['Field'], 'file') !== false) {
        $fileColumns[] = $row['Field'];
        echo "<p><strong>" . $row['Field'] . "</strong>: " . $row['Type'] . "</p>";
    }
}

echo "<h4>File Columns Found:</h4>";
echo "<ul>";
foreach ($fileColumns as $col) {
    echo "<li style='color: blue; font-weight: bold;'>$col</li>";
}
echo "</ul>";

// Check recent submissions
echo "<h4>Recent Submissions (file column data):</h4>";
if (in_array('file_url', $fileColumns)) {
    $recent = $conn->query("SELECT submission_id, assignment_id, student_id, file_url, submitted_at FROM assignment_submissions ORDER BY submitted_at DESC LIMIT 5");
    if ($recent->num_rows > 0) {
        echo "<table border='1'><tr><th>ID</th><th>Assignment</th><th>Student</th><th>file_url</th><th>Submitted</th></tr>";
        while ($row = $recent->fetch_assoc()) {
            $fileStatus = empty($row['file_url']) ? "❌ EMPTY" : "✅ " . $row['file_url'];
            echo "<tr><td>{$row['submission_id']}</td><td>{$row['assignment_id']}</td><td>{$row['student_id']}</td><td style='color: " . (empty($row['file_url']) ? 'red' : 'green') . ";'>$fileStatus</td><td>{$row['submitted_at']}</td></tr>";
        }
        echo "</table>";
    }
} elseif (in_array('file_path', $fileColumns)) {
    $recent = $conn->query("SELECT submission_id, assignment_id, student_id, file_path, submitted_at FROM assignment_submissions ORDER BY submitted_at DESC LIMIT 5");
    if ($recent->num_rows > 0) {
        echo "<table border='1'><tr><th>ID</th><th>Assignment</th><th>Student</th><th>file_path</th><th>Submitted</th></tr>";
        while ($row = $recent->fetch_assoc()) {
            $fileStatus = empty($row['file_path']) ? "❌ EMPTY" : "✅ " . $row['file_path'];
            echo "<tr><td>{$row['submission_id']}</td><td>{$row['assignment_id']}</td><td>{$row['student_id']}</td><td style='color: " . (empty($row['file_path']) ? 'red' : 'green') . ";'>$fileStatus</td><td>{$row['submitted_at']}</td></tr>";
        }
        echo "</table>";
    }
}
?>

<style>
table { border-collapse: collapse; width: 100%; }
th, td { padding: 8px; border: 1px solid #ddd; text-align: left; }
th { background-color: #f2f2f2; }
</style>
