<?php
// MINIMAL FILE UPLOAD DEBUG PATCH
// Add this code JUST BEFORE the INSERT statement in assignment_view.php

// ============ DEBUG FILE UPLOAD ISSUE ============
error_log("🔍 DEBUG FILE UPLOAD:");
error_log("📁 submissionFilePath: " . ($submissionFilePath ?? 'NULL'));
error_log("📄 submissionText length: " . strlen($submissionText ?? ''));
error_log("🆔 assignment_id: " . $assignment_id);
error_log("👤 student_id: " . $student_id);

// Check if file actually exists
if (!empty($submissionFilePath)) {
    $fullPath = "../uploads/assignments/" . $submissionFilePath;
    if (file_exists($fullPath)) {
        error_log("✅ File exists: " . $fullPath . " (size: " . filesize($fullPath) . " bytes)");
    } else {
        error_log("❌ File NOT found: " . $fullPath);
    }
}

// Log the exact INSERT parameters
error_log("📝 INSERT parameters being sent:");
error_log("1. assignment_id: " . $assignment_id);
error_log("2. student_id: " . $student_id);  
error_log("3. submission_text: " . substr($submissionText, 0, 100) . "...");
error_log("4. file_url: " . ($submissionFilePath ?? 'NULL'));
error_log("5. extracted_text: " . substr($extractedText, 0, 100) . "...");
// ================================================

/* 
INSTRUCTIONS:
1. Copy the above code
2. Paste it in assignment_view.php JUST BEFORE line 215 (the INSERT statement)
3. Test file upload
4. Check PHP error logs for detailed file upload information
5. This will show us exactly what's happening with file uploads
*/
?>
