<?php
// Direct Session Fix for API Endpoints
// This file can be included before any API call to ensure session consistency

// Start session with correct parameters
session_start();

// Check if we need to copy session data from the main cookie
if (empty($_SESSION['user_id']) && !empty($_COOKIE['PHPSESSID'])) {
    // We have a cookie but empty session - need to try using the same session ID
    $old_session_id = session_id();
    session_write_close(); // Close current session
    
    // Start new session with the ID from cookie
    session_id($_COOKIE['PHPSESSID']);
    session_start();
    
    // Log the fix attempt
    error_log("Session Fix: Changed session ID from {$old_session_id} to {$_COOKIE['PHPSESSID']}");
}

// Debug output
return [
    'fixed' => true,
    'session_id' => session_id(),
    'user_id' => $_SESSION['user_id'] ?? null,
    'user_role' => $_SESSION['user_role'] ?? null
];
?>
