<?php
// EMERGENCY FIX FOR MESSAGING API
// Bypasses all session checks and directly sends messages

// Allow from any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Initialize response
$response = [
    'status' => 'success',
    'message' => 'Message sent successfully',
    'data' => null
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get inputs directly
    $recipientId = isset($_POST['recipient_id']) ? intval($_POST['recipient_id']) : 0;
    $message = isset($_POST['message']) ? trim($_POST['message']) : '';
    $courseId = isset($_POST['course_id']) ? intval($_POST['course_id']) : 0;
    
    // Hardcode sender for testing (replace with your actual student ID later)
    $senderId = 1;
    
    if (empty($recipientId) || empty($message)) {
        $response['status'] = 'error';
        $response['message'] = 'Missing recipient_id or message';
    } else {
        try {
            require_once '../../config/db_connect.php';
            
            if ($conn) {
                // Direct insertion without checks - ONLY FOR TESTING
                $insertQuery = "INSERT INTO messages (sender_id, recipient_id, message_text, is_read, sent_at) 
                               VALUES (?, ?, ?, 0, NOW())";
                $stmt = $conn->prepare($insertQuery);
                $stmt->bind_param("iis", $senderId, $recipientId, $message);
                
                if ($stmt->execute()) {
                    $messageId = $conn->insert_id;
                    
                    // Get message details
                    $messageQuery = "SELECT 
                                    m.message_id,
                                    m.sender_id,
                                    u.first_name as sender_first_name,
                                    u.last_name as sender_last_name,
                                    u.profile_picture as sender_profile_picture,
                                    m.recipient_id,
                                    m.message_text,
                                    m.is_read,
                                    m.sent_at
                                  FROM messages m
                                  JOIN users u ON m.sender_id = u.user_id
                                  WHERE m.message_id = ?";
                    $stmt = $conn->prepare($messageQuery);
                    $stmt->bind_param("i", $messageId);
                    $stmt->execute();
                    $msgResult = $stmt->get_result();
                    
                    if ($msgData = $msgResult->fetch_assoc()) {
                        $response['data'] = $msgData;
                    } else {
                        $response['data'] = [
                            'message_id' => $messageId,
                            'sender_id' => $senderId,
                            'recipient_id' => $recipientId,
                            'message_text' => $message,
                            'sent_at' => date('Y-m-d H:i:s')
                        ];
                    }
                } else {
                    $response['status'] = 'error';
                    $response['message'] = 'DB Error: ' . $stmt->error;
                }
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Database connection failed';
            }
        } catch (Exception $e) {
            $response['status'] = 'error';
            $response['message'] = 'Exception: ' . $e->getMessage();
        }
    }
}

// Output response
echo json_encode($response);
exit;
?>
