<?php
/**
 * Session Test API
 * Quick test to check if session is working properly
 */

// Configure session for live server environment
ini_set('session.cookie_path', '/');
ini_set('session.cookie_domain', '.panaditeacademy.com');
ini_set('session.cookie_secure', true);  // For HTTPS
ini_set('session.cookie_httponly', true);
ini_set('session.use_strict_mode', true);

session_start();

header('Content-Type: application/json');

// Debug all session data
echo json_encode([
    'session_data' => $_SESSION,
    'session_id' => session_id(),
    'session_exists' => isset($_SESSION),
    'user_id' => $_SESSION['user_id'] ?? 'NOT SET',
    'student_id' => $_SESSION['student_id'] ?? 'NOT SET', 
    'id' => $_SESSION['id'] ?? 'NOT SET',
    'username' => $_SESSION['username'] ?? 'NOT SET',
    'post_data' => $_POST,
    'referer' => $_SERVER['HTTP_REFERER'] ?? 'NOT SET',
    'php_session_status' => session_status(),
    'session_name' => session_name(),
    'session_save_path' => session_save_path()
]);
?>
