<?php
// Include session start and auth functions
require_once '../includes/session_start.php';
require_once '../auth/functions.php';
require_once '../config/db_connect.php';

echo "<h1>Auth and Session Debug</h1>";

// Check PHP and session info
echo "<h2>PHP Info</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Session Status: " . (session_status() === PHP_SESSION_ACTIVE ? "ACTIVE" : "NOT ACTIVE") . "<br>";
echo "Session ID: " . session_id() . "<br>";

// Debug session data
echo "<h2>Session Variables</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

// Check if logged in
echo "<h2>Auth Status</h2>";
echo "Is Logged In: " . (isLoggedIn() ? "YES" : "NO") . "<br>";

// Get current user if available
$currentUser = getCurrentUser();
echo "<h2>Current User</h2>";
echo "<pre>";
print_r($currentUser);
echo "</pre>";

// Debug database connection
echo "<h2>Database Connection</h2>";
if (isset($conn)) {
    echo "Connection: ESTABLISHED<br>";
    
    try {
        // Get server info
        echo "Server Info: " . $conn->server_info . "<br>";
        echo "Host Info: " . $conn->host_info . "<br>";
        
        // Test a simple query
        $result = $conn->query("SELECT COUNT(*) as count FROM users");
        if ($result) {
            $row = $result->fetch_assoc();
            echo "Users count: " . $row['count'] . "<br>";
        } else {
            echo "Query failed: " . $conn->error . "<br>";
        }
    } catch (Exception $e) {
        echo "Database error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "Connection: FAILED<br>";
    echo "Error: Database connection not available";
}

// Create a test user if needed
echo "<h2>Create Test User (Demo Only)</h2>";
echo "<form method='post'>";
echo "<input type='hidden' name='create_test_user' value='1'>";
echo "<button type='submit'>Create Test Student User</button>";
echo "</form>";

if (isset($_POST['create_test_user'])) {
    // Create a test student user for debugging
    $username = "teststudent_" . rand(1000, 9999);
    $email = $username . "@example.com";
    $password = "password123";
    $firstName = "Test";
    $lastName = "Student";
    
    $result = registerUser($username, $email, $password, $firstName, $lastName, "student");
    
    echo "<h3>User Creation Result:</h3>";
    echo "<pre>";
    print_r($result);
    echo "</pre>";
    
    if ($result['success']) {
        echo "<h3>Login Test:</h3>";
        $loginResult = loginUser($username, $password);
        echo "<pre>";
        print_r($loginResult);
        echo "</pre>";
        
        if ($loginResult['success']) {
            echo "<p>Successfully created and logged in as test user. <a href='dashboard.php'>Go to Dashboard</a></p>";
        }
    }
}

// Login form for testing
echo "<h2>Test Login</h2>";
echo "<form method='post'>";
echo "Username: <input type='text' name='username'><br>";
echo "Password: <input type='password' name='password'><br>";
echo "<input type='hidden' name='do_login' value='1'>";
echo "<button type='submit'>Login</button>";
echo "</form>";

if (isset($_POST['do_login'])) {
    $loginResult = loginUser($_POST['username'], $_POST['password']);
    
    echo "<h3>Login Result:</h3>";
    echo "<pre>";
    print_r($loginResult);
    echo "</pre>";
    
    if ($loginResult['success']) {
        echo "<p>Successfully logged in. <a href='dashboard.php'>Go to Dashboard</a></p>";
    }
}
?>
